/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.data.management.copy.CopyableDataset;
import org.apache.gobblin.data.management.copy.SubsetFilesCopyableDataset;
import org.apache.gobblin.data.management.retention.profile.ConfigurableGlobDatasetFinder;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filters.RegexPathFilter;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsetFilesCopyableDatasetFinder
extends ConfigurableGlobDatasetFinder<CopyableDataset> {
    private static final Logger log = LoggerFactory.getLogger(SubsetFilesCopyableDatasetFinder.class);
    public static final String IDENTIFIER_PATTERN = "gobblin.copy.subsetFilesDatasetIdentifer";
    public static final String DEFAULT_IDENTIFIER_PATTERN = "(.*)";
    public static final String SUBSETFILES_REGEX_FILTER = "gobblin.copy.subsetFilesRegexFilter";
    public static final String DEFAULT_SUBSETFILES_REGEX_FILTER = ".*";
    protected final Path rootPath;
    protected Pattern identifierPattern;
    protected PathFilter pathFilter;
    protected final Map<String, List<FileStatus>> idToFileStatuses;
    private Optional<EventSubmitter> eventSubmitter;
    private SourceState state;

    public SubsetFilesCopyableDatasetFinder(FileSystem fs, Properties props) throws IOException {
        super(fs, props);
        this.identifierPattern = Pattern.compile(props.getProperty(IDENTIFIER_PATTERN, DEFAULT_IDENTIFIER_PATTERN));
        this.pathFilter = new RegexPathFilter(props.getProperty(SUBSETFILES_REGEX_FILTER, DEFAULT_SUBSETFILES_REGEX_FILTER));
        this.rootPath = PathUtils.deepestNonGlobPath((Path)this.datasetPattern);
        this.idToFileStatuses = new HashMap<String, List<FileStatus>>();
    }

    public SubsetFilesCopyableDatasetFinder(FileSystem fs, Properties props, EventSubmitter eventSubmitter) throws IOException {
        this(fs, props);
        this.eventSubmitter = Optional.of((Object)eventSubmitter);
    }

    public SubsetFilesCopyableDatasetFinder(FileSystem fs, Properties props, EventSubmitter eventSubmitter, SourceState state) throws IOException {
        this(fs, props, eventSubmitter);
        this.state = state;
    }

    @Override
    public List<CopyableDataset> findDatasets() throws IOException {
        FileStatus[] fileStatuss;
        ArrayList datasets = Lists.newArrayList();
        for (FileStatus datasetRootDir : fileStatuss = this.getDatasetDirs()) {
            datasets.addAll(this.generateDatasetsByIdentifier(datasetRootDir.getPath()));
        }
        return datasets;
    }

    public List<CopyableDataset> generateDatasetsByIdentifier(Path datasetRootDirPath) throws IOException {
        ArrayList datasets = Lists.newArrayList();
        FileStatus[] fileStatuses = this.fs.listStatus(datasetRootDirPath, this.getPathFilter());
        for (FileStatus fileStatus : fileStatuses) {
            Matcher result = this.identifierPattern.matcher(fileStatus.getPath().getName().toString());
            if (!result.find()) continue;
            String id = result.group(1);
            if (this.idToFileStatuses.containsKey(id)) {
                log.debug("Adding " + fileStatus.getPath() + " to " + id);
                this.idToFileStatuses.get(id).add(fileStatus);
                continue;
            }
            ArrayList<FileStatus> entry = new ArrayList<FileStatus>();
            entry.add(fileStatus);
            log.debug("Adding " + fileStatus.getPath() + " to " + id);
            this.idToFileStatuses.put(id, entry);
        }
        for (String id : this.idToFileStatuses.keySet()) {
            datasets.add(this.datasetAndPathWithIdentifier(datasetRootDirPath, id));
        }
        return datasets;
    }

    public CopyableDataset datasetAndPathWithIdentifier(Path path, String identifier) throws IOException {
        try {
            return (CopyableDataset)GobblinConstructorUtils.invokeLongestConstructor(SubsetFilesCopyableDataset.class, (Object[])new Object[]{this.fs, path, this.props, identifier, this.idToFileStatuses.get(identifier), this.eventSubmitter, this.state});
        }
        catch (ReflectiveOperationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public CopyableDataset datasetAtPath(Path path) throws IOException {
        throw new IOException("Not supported in " + this.getClass().getSimpleName());
    }

    public PathFilter getPathFilter() {
        return this.pathFilter;
    }

    public void setPathFilter(PathFilter pathFilter) {
        this.pathFilter = pathFilter;
    }
}

