/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.hive.filter;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.PartitionFilterGenerator;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LookbackPartitionFilterGenerator
implements PartitionFilterGenerator {
    public static final String PARTITION_COLUMN = "hive.dataset.partition.filter.datetime.column";
    public static final String LOOKBACK = "hive.dataset.partition.filter.datetime.lookback";
    public static final String DATETIME_FORMAT = "hive.dataset.partition.filter.datetime.format";
    private static final String ERROR_MESSAGE = LookbackPartitionFilterGenerator.class.getName() + " requires the following properties " + Arrays.toString(new String[]{"hive.dataset.partition.filter.datetime.column", "hive.dataset.partition.filter.datetime.lookback", "hive.dataset.partition.filter.datetime.format"});
    private final String partitionColumn;
    private final Period lookback;
    private final DateTimeFormatter formatter;

    public LookbackPartitionFilterGenerator(Properties properties) {
        Preconditions.checkArgument((boolean)properties.containsKey(PARTITION_COLUMN), (Object)ERROR_MESSAGE);
        Preconditions.checkArgument((boolean)properties.containsKey(LOOKBACK), (Object)ERROR_MESSAGE);
        Preconditions.checkArgument((boolean)properties.containsKey(DATETIME_FORMAT), (Object)ERROR_MESSAGE);
        this.partitionColumn = properties.getProperty(PARTITION_COLUMN);
        this.lookback = Period.parse((String)properties.getProperty(LOOKBACK));
        this.formatter = DateTimeFormat.forPattern((String)properties.getProperty(DATETIME_FORMAT));
    }

    @Override
    public String getFilter(HiveDataset hiveDataset) {
        DateTime limitDate = new DateTime().minus((ReadablePeriod)this.lookback);
        return String.format("%s >= \"%s\"", this.partitionColumn, this.formatter.print((ReadableInstant)limitDate));
    }
}

