/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.data.management.copy.replication.CopyRoute;
import org.apache.gobblin.data.management.copy.replication.CopyRouteGeneratorOptimizer;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.source.extractor.ComparableWatermark;

@Alias(value="OptimizedLatency")
public class CopyRouteGeneratorOptimizedLatency
extends CopyRouteGeneratorOptimizer {
    @Override
    public Optional<CopyRoute> getOptimizedCopyRoute(List<CopyRoute> routes) {
        CopyRoute preferred = Collections.max(routes, new CopyRouteComparatorBySourceWatermark());
        return Optional.of((Object)preferred);
    }

    static class CopyRouteComparatorBySourceWatermark
    implements Comparator<CopyRoute>,
    Serializable {
        private static final long serialVersionUID = 1439642339646179830L;

        CopyRouteComparatorBySourceWatermark() {
        }

        @Override
        public int compare(CopyRoute o1, CopyRoute o2) {
            EndPoint from1 = o1.getCopyFrom();
            EndPoint from2 = o2.getCopyFrom();
            Optional<ComparableWatermark> w1 = from1.getWatermark();
            Optional<ComparableWatermark> w2 = from2.getWatermark();
            if (!w1.isPresent() && !w2.isPresent()) {
                return 0;
            }
            if (!w2.isPresent()) {
                return 1;
            }
            if (!w1.isPresent()) {
                return -1;
            }
            return ((ComparableWatermark)w1.get()).compareTo(w2.get());
        }
    }
}

