/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.version.DatasetStateStoreVersion;
import org.apache.gobblin.data.management.version.DatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.metastore.DatasetStoreDataset;
import org.apache.gobblin.metastore.metadata.DatasetStateStoreEntryManager;

public abstract class CleanableDatasetStoreDataset<T extends DatasetVersion>
extends DatasetStoreDataset
implements CleanableDataset {
    public CleanableDatasetStoreDataset(DatasetStoreDataset.Key key, List<DatasetStateStoreEntryManager> entries) {
        super(key, entries);
    }

    public abstract VersionFinder<? extends T> getVersionFinder();

    public abstract VersionSelectionPolicy<T> getVersionSelectionPolicy();

    @Override
    public void clean() throws IOException {
        ArrayList versions = Lists.newArrayList(this.getVersionFinder().findDatasetVersions(this));
        Collections.sort(versions, Collections.reverseOrder());
        Collection<T> deletableVersions = this.getVersionSelectionPolicy().listSelectedVersions(versions);
        for (T version : deletableVersions) {
            ((DatasetStateStoreVersion)version).getEntry().delete();
        }
    }
}

