/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.policy.SelectBeforeTimeBasedPolicy;
import org.apache.gobblin.data.management.policy.VersionSelectionPolicy;
import org.apache.gobblin.data.management.retention.dataset.CleanableDataset;
import org.apache.gobblin.data.management.retention.dataset.FsCleanableHelper;
import org.apache.gobblin.data.management.retention.version.HiveDatasetVersionCleaner;
import org.apache.gobblin.data.management.version.HiveDatasetVersion;
import org.apache.gobblin.data.management.version.finder.AbstractHiveDatasetVersionFinder;
import org.apache.gobblin.data.management.version.finder.DatePartitionHiveVersionFinder;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanableHiveDataset
extends HiveDataset
implements CleanableDataset,
FileSystemDataset {
    private static final Logger log = LoggerFactory.getLogger(CleanableHiveDataset.class);
    private static final String SHOULD_DELETE_DATA_KEY = "gobblin.retention.hive.shouldDeleteData";
    private static final String SHOULD_DELETE_DATA_DEFAULT = Boolean.toString(false);
    private static final String VERSION_FINDER_CLASS_KEY = "version.finder.class";
    private static final String DEFAULT_VERSION_FINDER_CLASS = DatePartitionHiveVersionFinder.class.getName();
    private static final String SELECTION_POLICY_CLASS_KEY = "selection.policy.class";
    private static final String DEFAULT_SELECTION_POLICY_CLASS = SelectBeforeTimeBasedPolicy.class.getName();
    private final VersionSelectionPolicy hiveSelectionPolicy;
    private final AbstractHiveDatasetVersionFinder hiveDatasetVersionFinder;
    private final boolean simulate;
    private final boolean shouldDeleteData;
    private final FsCleanableHelper fsCleanableHelper;

    public CleanableHiveDataset(FileSystem fs, HiveMetastoreClientPool clientPool, Table table, Properties jobProps, Config config) throws IOException {
        super(fs, clientPool, table, jobProps, config);
        try {
            this.hiveSelectionPolicy = (VersionSelectionPolicy)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(ConfigUtils.getString((Config)this.datasetConfig, (String)SELECTION_POLICY_CLASS_KEY, (String)DEFAULT_SELECTION_POLICY_CLASS)), (List[])new List[]{ImmutableList.of((Object)this.datasetConfig, (Object)jobProps), ImmutableList.of((Object)this.datasetConfig), ImmutableList.of((Object)jobProps)});
            log.info(String.format("Configured selection policy %s for dataset:%s with config %s", ConfigUtils.getString((Config)this.datasetConfig, (String)SELECTION_POLICY_CLASS_KEY, (String)DEFAULT_SELECTION_POLICY_CLASS), this.datasetURN(), this.datasetConfig.root().render(ConfigRenderOptions.concise())));
            this.hiveDatasetVersionFinder = (AbstractHiveDatasetVersionFinder)GobblinConstructorUtils.invokeFirstConstructor(Class.forName(ConfigUtils.getString((Config)this.datasetConfig, (String)VERSION_FINDER_CLASS_KEY, (String)DEFAULT_VERSION_FINDER_CLASS)), (List[])new List[]{ImmutableList.of((Object)this.fs, (Object)this.datasetConfig), ImmutableList.of((Object)this.fs, (Object)jobProps)});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to instantiate CleanableHiveDataset", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        this.fsCleanableHelper = new FsCleanableHelper(fs, jobProps, this.datasetConfig, log);
        this.shouldDeleteData = Boolean.valueOf(jobProps.getProperty(SHOULD_DELETE_DATA_KEY, SHOULD_DELETE_DATA_DEFAULT));
        this.simulate = Boolean.valueOf(jobProps.getProperty("gobblin.retention.simulate", FsCleanableHelper.SIMULATE_DEFAULT));
    }

    @Override
    public void clean() throws IOException {
        ArrayList versions = Lists.newArrayList(this.hiveDatasetVersionFinder.findDatasetVersions(this));
        if (versions.isEmpty()) {
            log.warn(String.format("No dataset version can be found. Ignoring %s", this.getTable().getCompleteName()));
            return;
        }
        Collections.sort(versions, Collections.reverseOrder());
        Collection deletableVersions = this.hiveSelectionPolicy.listSelectedVersions(versions);
        log.info(String.format("Cleaning dataset %s .Will drop %s out of %s partitions.", this.datasetURN(), deletableVersions.size(), versions.size()));
        ArrayList exceptions = Lists.newArrayList();
        for (HiveDatasetVersion hiveDatasetVersion : deletableVersions) {
            try {
                HiveDatasetVersionCleaner hiveDatasetVersionCleaner = new HiveDatasetVersionCleaner(hiveDatasetVersion, this);
                hiveDatasetVersionCleaner.preCleanAction();
                hiveDatasetVersionCleaner.clean();
                hiveDatasetVersionCleaner.postCleanAction();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new RuntimeException(String.format("Deletion failed for %s partitions", exceptions.size()));
        }
    }

    public Path datasetRoot() {
        return super.getTable().getDataLocation();
    }

    public VersionSelectionPolicy getHiveSelectionPolicy() {
        return this.hiveSelectionPolicy;
    }

    public AbstractHiveDatasetVersionFinder getHiveDatasetVersionFinder() {
        return this.hiveDatasetVersionFinder;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public boolean isShouldDeleteData() {
        return this.shouldDeleteData;
    }

    public FsCleanableHelper getFsCleanableHelper() {
        return this.fsCleanableHelper;
    }
}

