/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.policy.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.gobblin.data.management.retention.version.StringDatasetVersion;

public class WhitelistPredicate
implements Predicate<StringDatasetVersion> {
    public static final String WHITELIST_PATTERN_KEY = "gobblin.retention.retention.whitelist.pattern";
    private final Pattern whitelist;

    public WhitelistPredicate(Properties properties) {
        Preconditions.checkArgument((boolean)properties.containsKey(WHITELIST_PATTERN_KEY));
        this.whitelist = Pattern.compile(properties.getProperty(WHITELIST_PATTERN_KEY));
    }

    public boolean apply(StringDatasetVersion input) {
        return this.whitelist.matcher(input.getVersion()).find();
    }
}

