/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.version.finder;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.gobblin.data.management.version.FileSystemDatasetVersion;
import org.apache.gobblin.data.management.version.TimestampedDatasetVersion;
import org.apache.gobblin.data.management.version.finder.VersionFinder;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.util.FileListUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLevelTimestampVersionFinder
implements VersionFinder<TimestampedDatasetVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLevelTimestampVersionFinder.class);
    private final FileSystem fs;

    public FileLevelTimestampVersionFinder(FileSystem fs, Properties props) {
        this(fs, ConfigFactory.parseProperties((Properties)props));
    }

    public FileLevelTimestampVersionFinder(FileSystem fs, Config config) {
        this.fs = fs;
    }

    @Override
    public Class<? extends FileSystemDatasetVersion> versionClass() {
        return TimestampedDatasetVersion.class;
    }

    @Override
    public Collection<TimestampedDatasetVersion> findDatasetVersions(Dataset dataset) {
        FileSystemDataset fsDataset = (FileSystemDataset)dataset;
        try {
            ArrayList timestampedVersions = Lists.newArrayList();
            for (FileStatus fileStatus : FileListUtils.listMostNestedPathRecursively((FileSystem)this.fs, (Path)fsDataset.datasetRoot())) {
                timestampedVersions.add(new TimestampedDatasetVersion(new DateTime(fileStatus.getModificationTime()), fileStatus.getPath()));
            }
            return timestampedVersions;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to get ModifiedTimeStamp for candidate dataset version at " + fsDataset.datasetRoot() + ". Ignoring.");
            return Lists.newArrayList();
        }
    }
}

