/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.util;

import java.util.Map;

public class MapUtil {
    public static <K, V> V getWithDefault(Map<K, ? extends Object> map, K key, V defaultValue, Class<V> valueClass) {
        Object actualValue = map.get(key);
        if (actualValue == null) {
            return defaultValue;
        }
        if (valueClass.isAssignableFrom(actualValue.getClass())) {
            return (V)actualValue;
        }
        if (!(actualValue instanceof String)) {
            throw new IllegalArgumentException("Unsupported actual value type: " + actualValue.getClass());
        }
        String valStr = (String)actualValue;
        if (valueClass.equals(Double.class)) {
            return (V)Double.valueOf(Double.parseDouble(valStr));
        }
        if (valueClass.equals(Float.class)) {
            return (V)Float.valueOf(Float.parseFloat(valStr));
        }
        if (valueClass.equals(Long.class)) {
            return (V)Long.valueOf(Long.parseLong(valStr));
        }
        if (valueClass.equals(Integer.class)) {
            return (V)Integer.valueOf(Integer.parseInt(valStr));
        }
        if (valueClass.equals(Boolean.class)) {
            return (V)Boolean.valueOf(Boolean.parseBoolean(valStr));
        }
        throw new IllegalArgumentException("Unsupported expected value type: " + valueClass + " and value = " + actualValue);
    }

    public static <K, V> V getWithDefault(Map<K, ? extends Object> map, K key, V defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("received null default value for key = " + key);
        }
        return MapUtil.getWithDefault(map, key, defaultValue, defaultValue.getClass());
    }

    private MapUtil() {
    }
}

