/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AbstractIdleService;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.spec_catalog.FlowCatalog;
import org.apache.gobblin.runtime.spec_store.FSSpecStore;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.PullFileLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitConfigMonitor
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(GitConfigMonitor.class);
    private static final String SPEC_DESCRIPTION = "Git-based flow config";
    private static final String SPEC_VERSION = "";
    private static final int TERMINATION_TIMEOUT = 30;
    private static final int CONFIG_FILE_DEPTH = 3;
    private static final String REMOTE_NAME = "origin";
    private final ScheduledExecutorService scheduledExecutor;
    private final GitRepository gitRepo;
    private final int pollingInterval;
    private final String repositoryDir;
    private final String configDir;
    private final Path configDirPath;
    private final FlowCatalog flowCatalog;
    private final PullFileLoader pullFileLoader;
    private final Config emptyConfig = ConfigFactory.empty();
    private volatile boolean isActive = false;

    GitConfigMonitor(Config config, FlowCatalog flowCatalog) {
        this.flowCatalog = flowCatalog;
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)"FetchGitConfExecutor")));
        Preconditions.checkArgument((boolean)config.hasPath("gitConfigMonitor.repositoryUri"), (Object)"gitConfigMonitor.repositoryUri needs to be specified.");
        String repositoryUri = config.getString("gitConfigMonitor.repositoryUri");
        this.repositoryDir = ConfigUtils.getString((Config)config, (String)"gitConfigMonitor.repositoryDirectory", (String)"git-flow-config");
        this.configDir = ConfigUtils.getString((Config)config, (String)"gitConfigMonitor.configDirectory", (String)"gobblin-config");
        this.pollingInterval = ConfigUtils.getInt((Config)config, (String)"gitConfigMonitor.pollingInterval", (Integer)60);
        String branchName = ConfigUtils.getString((Config)config, (String)"gitConfigMonitor.branchName", (String)"master");
        this.configDirPath = new Path(this.repositoryDir, this.configDir);
        try {
            this.pullFileLoader = new PullFileLoader(this.configDirPath, FileSystem.get((URI)URI.create("file:///"), (Configuration)new Configuration()), (Collection)PullFileLoader.DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS, (Collection)PullFileLoader.DEFAULT_HOCON_PULL_FILE_EXTENSIONS);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create pull file loader", e);
        }
        try {
            this.gitRepo = new GitRepository(repositoryUri, this.repositoryDir, branchName);
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException("Could not open git repository", e);
        }
    }

    protected void startUp() throws Exception {
        log.info("Starting the " + GitConfigMonitor.class.getSimpleName());
        log.info("Polling git with inteval {} ", (Object)this.pollingInterval);
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    GitConfigMonitor.this.processGitConfigChanges();
                }
                catch (IOException | GitAPIException e) {
                    log.error("Failed to process git config changes", e);
                }
            }
        }, 0L, this.pollingInterval, TimeUnit.SECONDS);
    }

    protected void shutDown() throws Exception {
        this.scheduledExecutor.shutdown();
        this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS);
    }

    public synchronized void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
    }

    @VisibleForTesting
    void processGitConfigChanges() throws GitAPIException, IOException {
        if (!this.isActive || !this.flowCatalog.isRunning()) {
            log.info("GitConfigMonitor: skip poll since the JobCatalog is not yet running.");
            return;
        }
        List changes = this.gitRepo.getChanges();
        block5: for (DiffEntry change : changes) {
            switch (change.getChangeType()) {
                case ADD: 
                case MODIFY: {
                    this.addSpec(change);
                    continue block5;
                }
                case DELETE: {
                    this.removeSpec(change);
                    continue block5;
                }
                case RENAME: {
                    this.removeSpec(change);
                    this.addSpec(change);
                    continue block5;
                }
            }
            throw new RuntimeException("Unsupported change type " + change.getChangeType());
        }
        this.gitRepo.moveCheckpointAndHashesForward();
    }

    private void addSpec(DiffEntry change) {
        if (this.checkConfigFilePath(change.getNewPath())) {
            Path configFilePath = new Path(this.repositoryDir, change.getNewPath());
            try {
                Config flowConfig = this.loadConfigFileWithFlowNameOverrides(configFilePath);
                this.flowCatalog.put((Spec)FlowSpec.builder().withConfig(flowConfig).withVersion(SPEC_VERSION).withDescription(SPEC_DESCRIPTION).build());
            }
            catch (IOException e) {
                log.warn("Could not load config file: " + configFilePath);
            }
        }
    }

    private void removeSpec(DiffEntry change) {
        if (this.checkConfigFilePath(change.getOldPath())) {
            Path configFilePath = new Path(this.repositoryDir, change.getOldPath());
            String flowName = FSSpecStore.getSpecName((Path)configFilePath);
            String flowGroup = FSSpecStore.getSpecGroup((Path)configFilePath);
            Config dummyConfig = ConfigBuilder.create().addPrimitive("flow.group", (Object)flowGroup).addPrimitive("flow.name", (Object)flowName).build();
            FlowSpec spec = FlowSpec.builder().withConfig(dummyConfig).withVersion(SPEC_VERSION).withDescription(SPEC_DESCRIPTION).build();
            this.flowCatalog.remove(spec.getUri());
        }
    }

    private boolean checkConfigFilePath(String configFilePath) {
        Path configFile = new Path(configFilePath);
        String fileExtension = Files.getFileExtension((String)configFile.getName());
        if (configFile.depth() != 3 || !configFile.getParent().getParent().getName().equals(this.configDir) || !PullFileLoader.DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS.contains(fileExtension) && !PullFileLoader.DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS.contains(fileExtension)) {
            log.warn("Changed file does not conform to directory structure and file name format, skipping: " + configFilePath);
            return false;
        }
        return true;
    }

    private Config loadConfigFileWithFlowNameOverrides(Path configFilePath) throws IOException {
        Config flowConfig = this.pullFileLoader.loadPullFile(configFilePath, this.emptyConfig, false);
        String flowName = FSSpecStore.getSpecName((Path)configFilePath);
        String flowGroup = FSSpecStore.getSpecGroup((Path)configFilePath);
        return flowConfig.withValue("flow.name", ConfigValueFactory.fromAnyRef((Object)flowName)).withValue("flow.group", ConfigValueFactory.fromAnyRef((Object)flowGroup));
    }

    private static class GitRepository {
        private static final String CHECKPOINT_FILE = "checkpoint.txt";
        private static final String CHECKPOINT_FILE_TMP = "checkpoint.tmp";
        private final String repoUri;
        private final String repoDir;
        private final String branchName;
        private Git git;
        private String lastProcessedGitHash;
        private String latestGitHash;

        private GitRepository(String repoUri, String repoDir, String branchName) throws GitAPIException, IOException {
            this.repoUri = repoUri;
            this.repoDir = repoDir;
            this.branchName = branchName;
            this.initRepository();
        }

        private void initRepository() throws GitAPIException, IOException {
            block6: {
                File repoDirFile = new File(this.repoDir);
                try {
                    this.git = Git.open((File)repoDirFile);
                    String uri = this.git.getRepository().getConfig().getString("remote", GitConfigMonitor.REMOTE_NAME, "url");
                    if (!uri.equals(this.repoUri)) {
                        throw new RuntimeException("Repo at " + this.repoDir + " has uri " + uri + " instead of " + this.repoUri);
                    }
                }
                catch (RepositoryNotFoundException e) {
                    this.git = Git.cloneRepository().setDirectory(repoDirFile).setURI(this.repoUri).setBranch(this.branchName).call();
                }
                try {
                    this.lastProcessedGitHash = this.readCheckpoint();
                }
                catch (FileNotFoundException e) {
                    Iterable logs = this.git.log().call();
                    RevCommit lastLog = null;
                    Iterator iterator = logs.iterator();
                    while (iterator.hasNext()) {
                        RevCommit log;
                        lastLog = log = (RevCommit)iterator.next();
                    }
                    if (lastLog == null) break block6;
                    this.lastProcessedGitHash = lastLog.getName();
                }
            }
            this.latestGitHash = this.lastProcessedGitHash;
        }

        private String readCheckpoint() throws IOException {
            File checkpointFile = new File(this.repoDir, CHECKPOINT_FILE);
            return Files.toString((File)checkpointFile, (Charset)Charsets.UTF_8);
        }

        private void writeCheckpoint(String gitHash) throws IOException {
            File tmpCheckpointFile = new File(this.repoDir, CHECKPOINT_FILE_TMP);
            File checkpointFile = new File(this.repoDir, CHECKPOINT_FILE);
            Files.write((CharSequence)gitHash, (File)tmpCheckpointFile, (Charset)Charsets.UTF_8);
            Files.move((File)tmpCheckpointFile, (File)checkpointFile);
        }

        private void moveCheckpointAndHashesForward() throws IOException {
            this.lastProcessedGitHash = this.latestGitHash;
            this.writeCheckpoint(this.latestGitHash);
        }

        private List<DiffEntry> getChanges() throws GitAPIException, IOException {
            ObjectId oldHeadTree = this.git.getRepository().resolve(this.lastProcessedGitHash + "^{tree}");
            this.git.fetch().setRemote(GitConfigMonitor.REMOTE_NAME).call();
            this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + this.branchName).call();
            ObjectId head = this.git.getRepository().resolve("HEAD");
            ObjectId headTree = this.git.getRepository().resolve("HEAD^{tree}");
            this.latestGitHash = head.getName();
            ObjectReader reader = this.git.getRepository().newObjectReader();
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            oldTreeIter.reset(reader, (AnyObjectId)oldHeadTree);
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)headTree);
            return this.git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setShowNameAndStatusOnly(true).call();
        }
    }
}

