/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.filesystem;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.util.filesystem.FileSystemInstrumentation;
import org.apache.gobblin.util.filesystem.FileSystemInstrumentationFactory;
import org.apache.gobblin.util.filesystem.FileSystemKey;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFileSystemInstrumentation
extends FileSystemInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MetricsFileSystemInstrumentation.class);
    private MetricContext metricContext;
    protected final Closer closer = Closer.create();
    @VisibleForTesting
    protected final ContextAwareTimer listStatusTimer;
    @VisibleForTesting
    protected final ContextAwareTimer listFilesTimer;
    @VisibleForTesting
    protected final ContextAwareTimer globStatusTimer;
    @VisibleForTesting
    protected final ContextAwareTimer mkdirTimer;
    @VisibleForTesting
    protected final ContextAwareTimer deleteTimer;
    @VisibleForTesting
    protected final ContextAwareTimer renameTimer;
    @VisibleForTesting
    protected final ContextAwareTimer createTimer;
    @VisibleForTesting
    protected final ContextAwareTimer openTimer;
    @VisibleForTesting
    protected final ContextAwareTimer setOwnerTimer;
    @VisibleForTesting
    protected final ContextAwareTimer getFileStatusTimer;
    @VisibleForTesting
    protected final ContextAwareTimer setPermissionTimer;
    @VisibleForTesting
    protected final ContextAwareTimer setTimesTimer;
    @VisibleForTesting
    protected final ContextAwareTimer appendTimer;
    @VisibleForTesting
    protected final ContextAwareTimer concatTimer;
    private final List<ContextAwareTimer> allTimers;

    public MetricsFileSystemInstrumentation(FileSystem underlying) {
        super(underlying);
        this.metricContext = new MetricContext.Builder(underlying.getUri() + "_metrics").build();
        this.metricContext = (MetricContext)this.closer.register((Closeable)this.metricContext);
        this.listStatusTimer = this.metricContext.timer("listStatus");
        this.listFilesTimer = this.metricContext.timer("listFiles");
        this.globStatusTimer = this.metricContext.timer("globStatus");
        this.mkdirTimer = this.metricContext.timer("mkdirs");
        this.renameTimer = this.metricContext.timer("rename");
        this.deleteTimer = this.metricContext.timer("delete");
        this.createTimer = this.metricContext.timer("create");
        this.openTimer = this.metricContext.timer("open");
        this.setOwnerTimer = this.metricContext.timer("setOwner");
        this.getFileStatusTimer = this.metricContext.timer("getFileStatus");
        this.setPermissionTimer = this.metricContext.timer("setPermission");
        this.setTimesTimer = this.metricContext.timer("setTimes");
        this.appendTimer = this.metricContext.timer("append");
        this.concatTimer = this.metricContext.timer("concat");
        this.allTimers = ImmutableList.builder().add((Object[])new ContextAwareTimer[]{this.listStatusTimer, this.listFilesTimer, this.globStatusTimer, this.mkdirTimer, this.renameTimer, this.deleteTimer, this.createTimer, this.openTimer, this.setOwnerTimer, this.getFileStatusTimer, this.setPermissionTimer, this.setTimesTimer, this.appendTimer, this.concatTimer}).build();
    }

    protected void onClose() {
        StringBuilder message = new StringBuilder();
        message.append("========================").append("\n");
        message.append("Statistics for FileSystem: ").append(this.getUri()).append("\n");
        message.append("------------------------").append("\n");
        message.append("method\tcalls\tmean time(ns)\t99 percentile(ns)").append("\n");
        for (ContextAwareTimer timer : this.allTimers) {
            if (timer.getCount() <= 0L) continue;
            message.append(timer.getName()).append("\t").append(timer.getCount()).append("\t").append(timer.getSnapshot().getMean()).append("\t").append(timer.getSnapshot().get99thPercentile()).append("\n");
        }
        message.append("------------------------").append("\n");
        log.info(message.toString());
        super.onClose();
    }

    public void close() throws IOException {
        super.close();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.mkdirTimer.time(), "mkdirs", f, permission);){
            boolean bl = super.mkdirs(f, permission);
            return bl;
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.renameTimer.time(), "rename", src, dst);){
            boolean bl = super.rename(src, dst);
            return bl;
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.deleteTimer.time(), "delete", f, recursive);){
            boolean bl = super.delete(f, recursive);
            return bl;
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.listStatusTimer.time(), "listStatus", path);){
            FileStatus[] statuses = super.listStatus(path);
            context.setResult(statuses);
            FileStatus[] fileStatusArray = statuses;
            return fileStatusArray;
        }
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.globStatusTimer.time(), "globStatus", pathPattern);){
            FileStatus[] statuses = super.globStatus(pathPattern);
            context.setResult(statuses);
            FileStatus[] fileStatusArray = statuses;
            return fileStatusArray;
        }
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.globStatusTimer.time(), "globStatus", pathPattern, filter);){
            FileStatus[] statuses = super.globStatus(pathPattern, filter);
            context.setResult(statuses);
            FileStatus[] fileStatusArray = statuses;
            return fileStatusArray;
        }
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.listFilesTimer.time(), "listFiles", f, recursive);){
            RemoteIterator remoteIterator = super.listFiles(f, recursive);
            return remoteIterator;
        }
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.createTimer.time(), "create", f, permission, overwrite, bufferSize, replication, blockSize, progress);){
            FSDataOutputStream fSDataOutputStream = super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
            return fSDataOutputStream;
        }
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.openTimer.time(), "open", f, bufferSize);){
            FSDataInputStream fSDataInputStream = super.open(f, bufferSize);
            return fSDataInputStream;
        }
    }

    public void setOwner(Path f, String user, String group) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.setOwnerTimer.time(), "setOwner", f, user, group);){
            super.setOwner(f, user, group);
        }
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.getFileStatusTimer.time(), "getFileStatus", f);){
            FileStatus fileStatus = super.getFileStatus(f);
            return fileStatus;
        }
    }

    public void setPermission(Path f, FsPermission permission) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.setPermissionTimer.time(), "setPermission", f, permission);){
            super.setPermission(f, permission);
        }
    }

    public void setTimes(Path f, long t, long a) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.setTimesTimer.time(), "setTimes", f, t, a);){
            super.setTimes(f, t, a);
        }
    }

    public FSDataOutputStream append(Path p, int bufferSize, Progressable progress) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.appendTimer.time(), "append", p);){
            FSDataOutputStream fSDataOutputStream = super.append(p, bufferSize, progress);
            return fSDataOutputStream;
        }
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        try (TimerContextWithLog context = new TimerContextWithLog(this.concatTimer.time(), "concat", trg, psrcs);){
            super.concat(trg, psrcs);
        }
    }

    private static class TimerContextWithLog
    implements Closeable {
        Timer.Context context;
        String operation;
        List<Object> parameters;
        long startTick;
        Object result;
        private static final Logger LOG = LoggerFactory.getLogger(TimerContextWithLog.class);

        public TimerContextWithLog(Timer.Context context, String operation, Object ... values) {
            this.context = context;
            this.startTick = System.nanoTime();
            this.operation = operation;
            this.parameters = new ArrayList<Object>(Arrays.asList(values));
            this.result = null;
        }

        public void setResult(Object rst) {
            this.result = rst;
        }

        @Override
        public void close() {
            long duration = System.nanoTime() - this.startTick;
            if (this.result instanceof FileStatus[]) {
                LOG.debug("HDFS operation {} with {} takes {} nanoseconds and returns {} files", new Object[]{this.operation, this.parameters, duration, ((FileStatus[])this.result).length});
            } else {
                LOG.debug("HDFS operation {} with {} takes {} nanoseconds", new Object[]{this.operation, this.parameters, duration});
            }
            this.context.close();
        }
    }

    public static class Factory<S extends ScopeType<S>>
    extends FileSystemInstrumentationFactory<S> {
        public FileSystem instrumentFileSystem(FileSystem fs, SharedResourcesBroker<S> broker, ConfigView<S, FileSystemKey> config) {
            return new MetricsFileSystemInstrumentation(fs);
        }
    }
}

