/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.ContextAwareCounter;
import org.apache.gobblin.metrics.ContextAwareGauge;
import org.apache.gobblin.metrics.ContextAwareHistogram;
import org.apache.gobblin.metrics.ContextAwareMeter;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.ContextAwareMetricFactory;
import org.apache.gobblin.metrics.ContextAwareMetricFactoryArgs;
import org.apache.gobblin.metrics.ContextAwareTimer;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.InnerMetricContext;
import org.apache.gobblin.metrics.RootMetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.context.NameConflictException;
import org.apache.gobblin.metrics.context.ReportableContext;
import org.apache.gobblin.metrics.notification.EventNotification;
import org.apache.gobblin.metrics.notification.Notification;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricContext
extends MetricRegistry
implements ReportableContext,
Closeable {
    protected final Closer closer;
    public static final String METRIC_CONTEXT_ID_TAG_NAME = "metricContextID";
    public static final String METRIC_CONTEXT_NAME_TAG_NAME = "metricContextName";
    private final InnerMetricContext innerMetricContext;
    private static final Logger LOG = LoggerFactory.getLogger(MetricContext.class);
    public static final String GOBBLIN_METRICS_NOTIFICATIONS_TIMER_NAME = "gobblin.metrics.notifications.timer";
    private final Map<UUID, Function<Notification, Void>> notificationTargets;
    private final ContextAwareTimer notificationTimer;
    private Optional<ExecutorService> executorServiceOptional;
    private final Set<ContextAwareMetric> contextAwareMetricsSet;

    protected MetricContext(String name, MetricContext parent, List<Tag<?>> tags, boolean isRoot) throws NameConflictException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        this.closer = Closer.create();
        try {
            this.innerMetricContext = (InnerMetricContext)this.closer.register((Closeable)new InnerMetricContext(this, name, parent, tags));
        }
        catch (ExecutionException ee) {
            throw Throwables.propagate((Throwable)ee);
        }
        this.contextAwareMetricsSet = Sets.newConcurrentHashSet();
        this.notificationTargets = Maps.newConcurrentMap();
        this.executorServiceOptional = Optional.absent();
        this.notificationTimer = new ContextAwareTimer(this, GOBBLIN_METRICS_NOTIFICATIONS_TIMER_NAME);
        this.register(this.notificationTimer);
        if (!isRoot) {
            RootMetricContext.get().addMetricContext(this);
        }
    }

    private synchronized ExecutorService getExecutorService() {
        if (!this.executorServiceOptional.isPresent()) {
            this.executorServiceOptional = Optional.of((Object)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool(ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOG), (Optional)Optional.of((Object)("MetricContext-" + this.getName() + "-%d"))))), (long)5L, (TimeUnit)TimeUnit.MINUTES));
        }
        return (ExecutorService)this.executorServiceOptional.get();
    }

    @Override
    public String getName() {
        return this.innerMetricContext.getName();
    }

    public Optional<MetricContext> getParent() {
        return this.innerMetricContext.getParent();
    }

    public Map<String, MetricContext> getChildContextsAsMap() {
        return this.innerMetricContext.getChildContextsAsMap();
    }

    @Override
    public SortedSet<String> getNames() {
        return this.innerMetricContext.getNames();
    }

    private void injectTagsToEvent(GobblinTrackingEvent event) {
        Map<String, String> originalMetadata = event.getMetadata();
        Map<String, Object> tags = this.getTagMap();
        HashMap newMetadata = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            newMetadata.put(entry.getKey(), entry.getValue().toString());
        }
        newMetadata.putAll(originalMetadata);
        event.setMetadata(newMetadata);
    }

    public void submitEvent(GobblinTrackingEvent nonReusableEvent) {
        nonReusableEvent.setTimestamp(System.currentTimeMillis());
        this.injectTagsToEvent(nonReusableEvent);
        EventNotification notification = new EventNotification(nonReusableEvent);
        this.sendNotification(notification);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.innerMetricContext.getMetrics();
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.innerMetricContext.getGauges(MetricFilter.ALL);
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.innerMetricContext.getGauges(filter);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.innerMetricContext.getCounters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.innerMetricContext.getCounters(filter);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.innerMetricContext.getHistograms(MetricFilter.ALL);
    }

    @Override
    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.innerMetricContext.getHistograms(filter);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.innerMetricContext.getMeters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.innerMetricContext.getMeters(filter);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.innerMetricContext.getTimers(MetricFilter.ALL);
    }

    @Override
    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.innerMetricContext.getTimers(filter);
    }

    public Counter counter(String name) {
        return this.contextAwareCounter(name);
    }

    public Meter meter(String name) {
        return this.contextAwareMeter(name);
    }

    public Histogram histogram(String name) {
        return this.contextAwareHistogram(name);
    }

    public ContextAwareTimer timer(String name) {
        return this.contextAwareTimer(name);
    }

    public synchronized <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        if (!(metric instanceof ContextAwareMetric)) {
            throw new UnsupportedOperationException("Can only register ContextAwareMetrics.");
        }
        return this.innerMetricContext.register(name, metric);
    }

    public <T extends ContextAwareMetric> T register(T metric) throws IllegalArgumentException {
        return this.register(metric.getName(), metric);
    }

    public ContextAwareCounter contextAwareCounter(String name) {
        return this.contextAwareCounter(name, ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_COUNTER_FACTORY);
    }

    public ContextAwareCounter contextAwareCounter(String name, ContextAwareMetricFactory<ContextAwareCounter> factory) {
        return this.innerMetricContext.getOrCreate(name, factory);
    }

    public ContextAwareMeter contextAwareMeter(String name) {
        return this.contextAwareMeter(name, ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_METER_FACTORY);
    }

    public ContextAwareMeter contextAwareMeter(String name, ContextAwareMetricFactory<ContextAwareMeter> factory) {
        return this.innerMetricContext.getOrCreate(name, factory);
    }

    public ContextAwareHistogram contextAwareHistogram(String name) {
        return this.innerMetricContext.getOrCreate(name, ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_HISTOGRAM_FACTORY);
    }

    public ContextAwareHistogram contextAwareHistogram(String name, long windowSize, TimeUnit unit) {
        ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs args = new ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs((MetricContext)this.innerMetricContext.getMetricContext().get(), name, windowSize, unit);
        return this.innerMetricContext.getOrCreate(ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_HISTOGRAM_FACTORY, args);
    }

    public ContextAwareTimer contextAwareTimer(String name) {
        return this.innerMetricContext.getOrCreate(name, ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_TIMER_FACTORY);
    }

    public ContextAwareTimer contextAwareTimer(String name, long windowSize, TimeUnit unit) {
        ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs args = new ContextAwareMetricFactoryArgs.SlidingTimeWindowArgs((MetricContext)this.innerMetricContext.getMetricContext().get(), name, windowSize, unit);
        return this.innerMetricContext.getOrCreate(ContextAwareMetricFactory.DEFAULT_CONTEXT_AWARE_TIMER_FACTORY, args);
    }

    public <T> ContextAwareGauge<T> newContextAwareGauge(String name, Gauge<T> gauge) {
        return new ContextAwareGauge<T>(this, name, gauge);
    }

    public synchronized boolean remove(String name) {
        return this.innerMetricContext.remove(name);
    }

    public void removeMatching(MetricFilter filter) {
        this.innerMetricContext.removeMatching(filter);
    }

    @Override
    public List<Tag<?>> getTags() {
        return this.innerMetricContext.getTags();
    }

    @Override
    public Map<String, Object> getTagMap() {
        return this.innerMetricContext.getTagMap();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public Builder childBuilder(String name) {
        return MetricContext.builder(name).hasParent(this);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public UUID addNotificationTarget(Function<Notification, Void> target) {
        UUID uuid = UUID.randomUUID();
        if (this.notificationTargets.containsKey(uuid)) {
            throw new RuntimeException("Failed to create notification target.");
        }
        this.notificationTargets.put(uuid, target);
        return uuid;
    }

    public void removeNotificationTarget(UUID key) {
        this.notificationTargets.remove(key);
    }

    public void sendNotification(Notification notification) {
        Timer.Context timer = this.notificationTimer.time();
        if (!this.notificationTargets.isEmpty()) {
            for (Map.Entry<UUID, Function<Notification, Void>> entry : this.notificationTargets.entrySet()) {
                try {
                    entry.getValue().apply((Object)notification);
                }
                catch (RuntimeException exception) {
                    LOG.warn("RuntimeException when running notification target. Skipping.", (Throwable)exception);
                }
            }
        }
        if (this.getParent().isPresent()) {
            ((MetricContext)this.getParent().get()).sendNotification(notification);
        }
        timer.stop();
    }

    void addChildContext(String childContextName, MetricContext childContext) throws NameConflictException, ExecutionException {
        this.innerMetricContext.addChildContext(childContextName, childContext);
    }

    void addToMetrics(ContextAwareMetric metric) {
        this.contextAwareMetricsSet.add(metric);
    }

    void removeFromMetrics(ContextAwareMetric metric) {
        this.contextAwareMetricsSet.remove(metric);
    }

    @VisibleForTesting
    void clearNotificationTargets() {
        this.notificationTargets.clear();
    }

    public InnerMetricContext getInnerMetricContext() {
        return this.innerMetricContext;
    }

    public static class Builder {
        private String name;
        private MetricContext parent = null;
        private final List<Tag<?>> tags = Lists.newArrayList();

        public Builder(String name) {
            this.name = name;
        }

        private Builder hasParent(MetricContext parent) {
            this.parent = parent;
            this.tags.addAll(parent.getTags());
            return this;
        }

        public Builder addTag(Tag<?> tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder addTags(Collection<Tag<?>> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public MetricContext build() {
            try {
                return this.buildStrict();
            }
            catch (NameConflictException nce) {
                String uuid = UUID.randomUUID().toString();
                LOG.warn("MetricContext with specified name already exists, appending UUID to the given name: " + uuid);
                this.name = this.name + "_" + uuid;
                try {
                    return this.buildStrict();
                }
                catch (NameConflictException nce2) {
                    throw Throwables.propagate((Throwable)nce2);
                }
            }
        }

        public MetricContext buildStrict() throws NameConflictException {
            if (this.parent == null) {
                this.parent = RootMetricContext.get();
            }
            return new MetricContext(this.name, this.parent, this.tags, false);
        }
    }
}

