/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.TimingEvent;

@Deprecated
public class EventSubmitter {
    public static final String EVENT_TYPE = "eventType";
    private final Map<String, String> metadata;
    private final String namespace;
    private final Optional<MetricContext> metricContext;

    private EventSubmitter(Builder builder) {
        this.metadata = builder.metadata;
        this.namespace = builder.namespace;
        this.metricContext = builder.metricContext;
    }

    public void submit(String name) {
        this.submit(name, (Map<String, String>)ImmutableMap.of());
    }

    public static void submit(Optional<EventSubmitter> submitter, String name) {
        if (submitter.isPresent()) {
            ((EventSubmitter)submitter.get()).submit(name);
        }
    }

    public void submit(String name, String ... metadataEls) {
        if (metadataEls.length % 2 != 0) {
            throw new IllegalArgumentException("Unmatched keys in metadata elements.");
        }
        HashMap metadata = Maps.newHashMap();
        for (int i = 0; i < metadataEls.length / 2; ++i) {
            metadata.put(metadataEls[2 * i], metadataEls[2 * i + 1]);
        }
        this.submit(name, metadata);
    }

    public static void submit(Optional<EventSubmitter> submitter, String name, String ... metadataEls) {
        if (submitter.isPresent()) {
            ((EventSubmitter)submitter.get()).submit(name, metadataEls);
        }
    }

    public void submit(String name, Map<String, String> additionalMetadata) {
        if (this.metricContext.isPresent()) {
            HashMap finalMetadata = Maps.newHashMap(this.metadata);
            if (!additionalMetadata.isEmpty()) {
                finalMetadata.putAll(additionalMetadata);
            }
            ((MetricContext)this.metricContext.get()).submitEvent(new GobblinTrackingEvent(0L, this.namespace, name, finalMetadata));
        }
    }

    public static void submit(Optional<EventSubmitter> submitter, String name, Map<String, String> additionalMetadata) {
        if (submitter.isPresent()) {
            ((EventSubmitter)submitter.get()).submit(name, additionalMetadata);
        }
    }

    public TimingEvent getTimingEvent(String name) {
        return new TimingEvent(this, name);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Optional<MetricContext> getMetricContext() {
        return this.metricContext;
    }

    public static class Builder {
        private final Optional<MetricContext> metricContext;
        private final Map<String, String> metadata;
        private final String namespace;

        public Builder(MetricContext metricContext, String namespace) {
            this((Optional<MetricContext>)Optional.fromNullable((Object)metricContext), namespace);
        }

        public Builder(Optional<MetricContext> metricContext, String namespace) {
            this.metricContext = metricContext;
            this.namespace = namespace;
            this.metadata = Maps.newHashMap();
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addMetadata(Map<? extends String, ? extends String> additionalMetadata) {
            this.metadata.putAll(additionalMetadata);
            return this;
        }

        public EventSubmitter build() {
            return new EventSubmitter(this);
        }
    }
}

