/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.event;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.event.GobblinEventBuilder;

public class FailureEventBuilder
extends GobblinEventBuilder {
    private static final String FAILURE_EVENT_TYPE = "FailureEvent";
    private static final String ROOT_CAUSE = "rootException";
    private Throwable rootCause;

    public FailureEventBuilder(String name) {
        this(name, "gobblin.event");
    }

    public FailureEventBuilder(String name, String namespace) {
        super(name, namespace);
        this.metadata.put("eventType", FAILURE_EVENT_TYPE);
    }

    public void setRootCause(Throwable t) {
        this.rootCause = FailureEventBuilder.getRootCause(t);
    }

    @Override
    public GobblinTrackingEvent build() {
        if (this.rootCause != null) {
            this.metadata.put(ROOT_CAUSE, ExceptionUtils.getStackTrace((Throwable)this.rootCause));
        }
        return new GobblinTrackingEvent(0L, this.namespace, this.name, this.metadata);
    }

    public static boolean isFailureEvent(GobblinTrackingEvent event) {
        String eventType = event.getMetadata().get("eventType");
        return StringUtils.isNotEmpty((String)eventType) && eventType.equals(FAILURE_EVENT_TYPE);
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
        if (rootCause == null) {
            rootCause = t;
        }
        return rootCause;
    }
}

