/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.metric.filter;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gobblin.metrics.metric.Metrics;

public class MetricTypeFilter
implements MetricFilter {
    private List<Metrics> allowedMetrics;

    public MetricTypeFilter(String allowedMetrics) {
        if (Strings.isNullOrEmpty((String)allowedMetrics)) {
            this.allowedMetrics = Lists.newArrayList((Object[])Metrics.values());
        } else {
            List allowedMetricsList = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)allowedMetrics);
            this.allowedMetrics = Lists.transform((List)allowedMetricsList, (Function)new Function<String, Metrics>(){

                @Nullable
                public Metrics apply(String input) {
                    return input == null ? null : Metrics.valueOf(input);
                }
            });
        }
    }

    public boolean matches(String name, Metric metric) {
        final Class<?> metricClass = metric.getClass();
        return Iterables.any(this.allowedMetrics, (Predicate)new Predicate<Metrics>(){

            public boolean apply(@Nullable Metrics input) {
                return input != null && input.getMetricClass().isAssignableFrom(metricClass);
            }
        });
    }
}

