/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter.util;

import com.google.common.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AvroSerializer<T extends SpecificRecord>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvroSerializer.class);
    private final Closer closer = Closer.create();
    private final Encoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream out = (DataOutputStream)this.closer.register((Closeable)new DataOutputStream(this.byteArrayOutputStream));
    private final SpecificDatumWriter<T> writer;
    private SchemaVersionWriter schemaVersionWriter;

    public AvroSerializer(Schema schema, SchemaVersionWriter schemaVersionWriter) throws IOException {
        this.encoder = this.getEncoder(schema, this.out);
        this.schemaVersionWriter = schemaVersionWriter;
        this.writer = new SpecificDatumWriter(schema);
    }

    public synchronized void setSchemaVersionWriter(SchemaVersionWriter schemaVersionWriter) {
        this.schemaVersionWriter = schemaVersionWriter;
    }

    protected abstract Encoder getEncoder(Schema var1, OutputStream var2) throws IOException;

    public synchronized byte[] serializeRecord(T record) {
        try {
            this.byteArrayOutputStream.reset();
            this.schemaVersionWriter.writeSchemaVersioningInformation(record.getSchema(), this.out);
            this.writer.write(record, this.encoder);
            this.encoder.flush();
            return this.byteArrayOutputStream.toByteArray();
        }
        catch (IOException exception) {
            LOGGER.warn("Could not serialize Avro record for Kafka Metrics.", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

