/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.google.common.base.Optional;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.aws.AWSSdkClient;
import org.apache.helix.messaging.AsyncCallback;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class AWSShutdownHandler
extends AsyncCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AWSShutdownHandler.class);
    private final AWSSdkClient awsSdkClient;
    private final Optional<List<String>> optionalLaunchConfigurationNames;
    private final Optional<List<String>> optionalAutoScalingGroupNames;

    public AWSShutdownHandler(AWSSdkClient awsSdkClient, Optional<List<String>> optionalLaunchConfigurationNames, Optional<List<String>> optionalAutoScalingGroupNames) {
        this.awsSdkClient = awsSdkClient;
        this.optionalLaunchConfigurationNames = optionalLaunchConfigurationNames;
        this.optionalAutoScalingGroupNames = optionalAutoScalingGroupNames;
    }

    public void onTimeOut() {
        LOGGER.warn("Timeout while waiting for Helix controller and participants shutdown. Moving ahead with forced shutdown of Amazon AutoScaling group");
        this.shutdownASG();
    }

    public void onReplyMessage(Message message) {
        LOGGER.info("Successfully shutdown Helix controller and participants shutdown. Moving ahead with graceful shutdown of Amazon AutoScaling group");
        this.shutdownASG();
    }

    private void shutdownASG() {
        if (this.optionalLaunchConfigurationNames.isPresent()) {
            for (String launchConfigurationName : (List)this.optionalLaunchConfigurationNames.get()) {
                try {
                    this.awsSdkClient.deleteLaunchConfiguration(launchConfigurationName);
                }
                catch (Exception e) {
                    LOGGER.warn("Issue in deleting launch configuration, please delete manually: " + launchConfigurationName + " Continuing to cleanup AutoScalingGroups", (Throwable)e);
                }
            }
        }
        if (this.optionalAutoScalingGroupNames.isPresent()) {
            for (String autoScalingGroupName : (List)this.optionalAutoScalingGroupNames.get()) {
                try {
                    this.awsSdkClient.deleteAutoScalingGroup(autoScalingGroupName, false);
                }
                catch (Exception e1) {
                    LOGGER.warn("Issue in deleting auto scaling group (in graceful mode): " + autoScalingGroupName + " Going to try forceful cleanup.", (Throwable)e1);
                    try {
                        this.awsSdkClient.deleteAutoScalingGroup(autoScalingGroupName, true);
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Issue in deleting auto scaling group (in forced mode), please delete manually: " + autoScalingGroupName + " Continuing to cleanup other resources", (Throwable)e2);
                    }
                }
            }
        }
    }
}

