/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.AzkabanExecutorServer;
import azkaban.execapp.FlowRunnerManager;
import azkaban.executor.ConnectorParams;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutorManagerException;
import azkaban.utils.FileIOUtils;
import azkaban.utils.JSONUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ExecutorServlet
extends HttpServlet
implements ConnectorParams {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger((String)ExecutorServlet.class.getName());
    public static final String JSON_MIME_TYPE = "application/json";
    private AzkabanExecutorServer application;
    private FlowRunnerManager flowRunnerManager;

    public void init(ServletConfig config) throws ServletException {
        this.application = (AzkabanExecutorServer)config.getServletContext().getAttribute("azkaban_app");
        if (this.application == null) {
            throw new IllegalStateException("No batch application is defined in the servlet context!");
        }
        this.flowRunnerManager = this.application.getFlowRunnerManager();
    }

    protected void writeJSON(HttpServletResponse resp, Object obj) throws IOException {
        resp.setContentType(JSON_MIME_TYPE);
        ObjectMapper mapper = new ObjectMapper();
        ServletOutputStream stream = resp.getOutputStream();
        mapper.writeValue((OutputStream)stream, obj);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        try {
            if (!this.hasParam(req, "action")) {
                logger.error((Object)"Parameter action not set");
                respMap.put("error", "Parameter action not set");
            } else {
                String action = this.getParam(req, "action");
                if (action.equals("update")) {
                    this.handleAjaxUpdateRequest(req, respMap);
                } else if (action.equals("ping")) {
                    respMap.put("status", "alive");
                } else {
                    int execid = Integer.parseInt(this.getParam(req, "execid"));
                    String user = this.getParam(req, "user", null);
                    logger.info((Object)("User " + user + " has called action " + action + " on " + execid));
                    if (action.equals("metadata")) {
                        this.handleFetchMetaDataEvent(execid, req, resp, respMap);
                    } else if (action.equals("log")) {
                        this.handleFetchLogEvent(execid, req, resp, respMap);
                    } else if (action.equals("attachments")) {
                        this.handleFetchAttachmentsEvent(execid, req, resp, respMap);
                    } else if (action.equals("execute")) {
                        this.handleAjaxExecute(req, respMap, execid);
                    } else if (action.equals("status")) {
                        this.handleAjaxFlowStatus(respMap, execid);
                    } else if (action.equals("cancel")) {
                        logger.info((Object)"Cancel called.");
                        this.handleAjaxCancel(respMap, execid, user);
                    } else if (action.equals("pause")) {
                        logger.info((Object)"Paused called.");
                        this.handleAjaxPause(respMap, execid, user);
                    } else if (action.equals("resume")) {
                        logger.info((Object)"Resume called.");
                        this.handleAjaxResume(respMap, execid, user);
                    } else if (action.equals("modifyExecution")) {
                        logger.info((Object)"Modify Execution Action");
                        this.handleModifyExecutionRequest(respMap, execid, user, req);
                    } else {
                        logger.error((Object)("action: '" + action + "' not supported."));
                        respMap.put("error", "action: '" + action + "' not supported.");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
        this.writeJSON(resp, respMap);
        resp.flushBuffer();
    }

    private void handleModifyExecutionRequest(Map<String, Object> respMap, int execId, String user, HttpServletRequest req) throws ServletException {
        if (!this.hasParam(req, "modifyType")) {
            respMap.put("error", "Modification type not set.");
        }
        String modificationType = this.getParam(req, "modifyType");
        try {
            if ("retryFailures".equals(modificationType)) {
                this.flowRunnerManager.retryFailures(execId, user);
            }
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleFetchLogEvent(int execId, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> respMap) throws ServletException {
        String type = this.getParam(req, "type");
        int startByte = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        if (type.equals("flow")) {
            try {
                FileIOUtils.LogData result = this.flowRunnerManager.readFlowLogs(execId, startByte, length);
                respMap.putAll(result.toObject());
            }
            catch (Exception e) {
                logger.error((Object)e);
                respMap.put("error", e.getMessage());
            }
        } else {
            int attempt = this.getIntParam(req, "attempt", 0);
            String jobId = this.getParam(req, "jobId");
            try {
                FileIOUtils.LogData result = this.flowRunnerManager.readJobLogs(execId, jobId, attempt, startByte, length);
                respMap.putAll(result.toObject());
            }
            catch (Exception e) {
                logger.error((Object)e);
                respMap.put("error", e.getMessage());
            }
        }
    }

    private void handleFetchAttachmentsEvent(int execId, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> respMap) throws ServletException {
        String jobId = this.getParam(req, "jobId");
        int attempt = this.getIntParam(req, "attempt", 0);
        try {
            List<Object> result = this.flowRunnerManager.readJobAttachments(execId, jobId, attempt);
            respMap.put("attachments", result);
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleFetchMetaDataEvent(int execId, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> respMap) throws ServletException {
        int startByte = this.getIntParam(req, "offset");
        int length = this.getIntParam(req, "length");
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        int attempt = this.getIntParam(req, "attempt", 0);
        String jobId = this.getParam(req, "jobId");
        try {
            FileIOUtils.JobMetaData result = this.flowRunnerManager.readJobMetaData(execId, jobId, attempt, startByte, length);
            respMap.putAll(result.toObject());
        }
        catch (Exception e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleAjaxUpdateRequest(HttpServletRequest req, Map<String, Object> respMap) throws ServletException, IOException {
        ArrayList updateTimesList = (ArrayList)JSONUtils.parseJSONFromString(this.getParam(req, "updatetime"));
        ArrayList execIDList = (ArrayList)JSONUtils.parseJSONFromString(this.getParam(req, "executionId"));
        ArrayList<Map<Object, Object>> updateList = new ArrayList<Map<Object, Object>>();
        for (int i = 0; i < execIDList.size(); ++i) {
            long updateTime = JSONUtils.getLongFromObject(updateTimesList.get(i));
            int execId = (Integer)execIDList.get(i);
            ExecutableFlow flow = this.flowRunnerManager.getExecutableFlow(execId);
            if (flow == null) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("error", "Flow does not exist");
                errorResponse.put("executionId", execId);
                updateList.add(errorResponse);
                continue;
            }
            if (flow.getUpdateTime() <= updateTime) continue;
            updateList.add(((ExecutableFlowBase)flow).toUpdateObject(updateTime));
        }
        respMap.put("updated", updateList);
    }

    private void handleAjaxExecute(HttpServletRequest req, Map<String, Object> respMap, int execId) throws ServletException {
        try {
            this.flowRunnerManager.submitFlow(execId);
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleAjaxFlowStatus(Map<String, Object> respMap, int execid) {
        ExecutableFlow flow = this.flowRunnerManager.getExecutableFlow(execid);
        if (flow == null) {
            respMap.put("status", "notfound");
        } else {
            respMap.put("status", flow.getStatus().toString());
            respMap.put("lasttime", flow.getUpdateTime());
        }
    }

    private void handleAjaxPause(Map<String, Object> respMap, int execid, String user) throws ServletException {
        if (user == null) {
            respMap.put("error", "user has not been set");
            return;
        }
        try {
            this.flowRunnerManager.pauseFlow(execid, user);
            respMap.put("status", "success");
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    private void handleAjaxResume(Map<String, Object> respMap, int execid, String user) throws ServletException {
        if (user == null) {
            respMap.put("error", "user has not been set");
            return;
        }
        try {
            this.flowRunnerManager.resumeFlow(execid, user);
            respMap.put("status", "success");
        }
        catch (ExecutorManagerException e) {
            e.printStackTrace();
            respMap.put("error", e.getMessage());
        }
    }

    private void handleAjaxCancel(Map<String, Object> respMap, int execid, String user) throws ServletException {
        if (user == null) {
            respMap.put("error", "user has not been set");
            return;
        }
        try {
            this.flowRunnerManager.cancelFlow(execid, user);
            respMap.put("status", "success");
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)e);
            respMap.put("error", e.getMessage());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    public boolean hasParam(HttpServletRequest request, String param) {
        return request.getParameter(param) != null;
    }

    public String getParam(HttpServletRequest request, String name) throws ServletException {
        String p = request.getParameter(name);
        if (p == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return p;
    }

    public String getParam(HttpServletRequest request, String name, String defaultVal) {
        String p = request.getParameter(name);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public int getIntParam(HttpServletRequest request, String name) throws ServletException {
        String p = this.getParam(request, name);
        return Integer.parseInt(p);
    }

    public int getIntParam(HttpServletRequest request, String name, int defaultVal) {
        if (this.hasParam(request, name)) {
            try {
                return this.getIntParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }
}

