/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.Status;
import azkaban.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutableJobInfo {
    private final int execId;
    private final int projectId;
    private final int version;
    private final String flowId;
    private final String jobId;
    private final long startTime;
    private final long endTime;
    private final Status status;
    private final int attempt;
    private ArrayList<Pair<String, String>> jobPath;

    public ExecutableJobInfo(int execId, int projectId, int version, String flowId, String jobId, long startTime, long endTime, Status status, int attempt) {
        this.execId = execId;
        this.projectId = projectId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.version = version;
        this.flowId = flowId;
        this.jobId = jobId;
        this.attempt = attempt;
        this.parseFlowId();
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getExecId() {
        return this.execId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String getImmediateFlowId() {
        if (this.jobPath.size() == 1) {
            return this.flowId;
        }
        Pair<String, String> pair = this.jobPath.get(this.jobPath.size() - 1);
        return pair.getSecond();
    }

    public String getHeadFlowId() {
        Pair<String, String> pair = this.jobPath.get(0);
        return pair.getFirst();
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public List<Pair<String, String>> getParsedFlowId() {
        return this.jobPath;
    }

    private void parseFlowId() {
        String[] flowPairs;
        this.jobPath = new ArrayList();
        for (String flowPair : flowPairs = this.flowId.split(",")) {
            String[] pairSplit = flowPair.split(":");
            Pair<String, String> pair = pairSplit.length == 1 ? new Pair<String, String>(pairSplit[0], pairSplit[0]) : new Pair<String, String>(pairSplit[0], pairSplit[1]);
            this.jobPath.add(pair);
        }
    }

    public String getJobIdPath() {
        String path = "";
        for (int i = 1; i < this.jobPath.size(); ++i) {
            Pair<String, String> pair = this.jobPath.get(i);
            path = path + pair.getFirst() + ":";
        }
        path = path + this.jobId;
        return path;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("execId", this.execId);
        map.put("version", this.version);
        map.put("flowId", this.flowId);
        map.put("jobId", this.jobId);
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        map.put("status", this.status.toString());
        map.put("attempt", this.attempt);
        return map;
    }
}

