/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype;

import azkaban.jobExecutor.JavaProcessJob;
import azkaban.jobExecutor.Job;
import azkaban.jobExecutor.NoopJob;
import azkaban.jobExecutor.ProcessJob;
import azkaban.jobExecutor.PythonJob;
import azkaban.jobExecutor.RubyJob;
import azkaban.jobExecutor.ScriptJob;
import azkaban.jobExecutor.utils.JobExecutionException;
import azkaban.jobtype.JobTypeManagerException;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobTypeManager {
    private final String jobtypePluginDir;
    private final ClassLoader parentLoader;
    public static final String DEFAULT_JOBTYPEPLUGINDIR = "plugins/jobtypes";
    private static final String JOBTYPECONFFILE = "plugin.properties";
    private static final String JOBTYPESYSCONFFILE = "private.properties";
    private static final String COMMONCONFFILE = "common.properties";
    private static final String COMMONSYSCONFFILE = "commonprivate.properties";
    private static final Logger logger = Logger.getLogger(JobTypeManager.class);
    private Map<String, Class<? extends Job>> jobToClass;
    private Map<String, Props> jobtypeJobProps;
    private Map<String, Props> jobtypeSysProps;

    public JobTypeManager(String jobtypePluginDir, ClassLoader parentClassLoader) {
        File pluginDir;
        this.jobtypePluginDir = jobtypePluginDir;
        this.parentLoader = parentClassLoader;
        this.jobToClass = new HashMap<String, Class<? extends Job>>();
        this.jobtypeJobProps = new HashMap<String, Props>();
        this.jobtypeSysProps = new HashMap<String, Props>();
        this.loadDefaultTypes();
        if (jobtypePluginDir != null && (pluginDir = new File(jobtypePluginDir)).exists()) {
            logger.info((Object)"job type plugin directory set. Loading extra job types.");
            try {
                this.loadPluginJobTypes();
            }
            catch (Exception e) {
                logger.info((Object)("Plugin jobtypes failed to load. " + e.getCause()));
                throw new JobTypeManagerException(e);
            }
        }
    }

    private void loadDefaultTypes() throws JobTypeManagerException {
        this.jobToClass.put("command", ProcessJob.class);
        this.jobToClass.put("javaprocess", JavaProcessJob.class);
        this.jobToClass.put("noop", NoopJob.class);
        this.jobToClass.put("python", PythonJob.class);
        this.jobToClass.put("ruby", RubyJob.class);
        this.jobToClass.put("script", ScriptJob.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginJobTypes() throws JobTypeManagerException {
        File jobPluginsDir = new File(this.jobtypePluginDir);
        if (!jobPluginsDir.exists()) {
            return;
        }
        if (!jobPluginsDir.isDirectory()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobtypePluginDir + " is not a directory!");
        }
        if (!jobPluginsDir.canRead()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobtypePluginDir + " is not readable!");
        }
        Props globalConf = null;
        Props globalSysConf = null;
        File confFile = JobTypeManager.findFilefromDir(jobPluginsDir, COMMONCONFFILE);
        File sysConfFile = JobTypeManager.findFilefromDir(jobPluginsDir, COMMONSYSCONFFILE);
        try {
            globalConf = confFile != null ? new Props(null, confFile) : new Props();
            globalSysConf = sysConfFile != null ? new Props(null, sysConfFile) : new Props();
        }
        catch (Exception e) {
            throw new JobTypeManagerException("Failed to get global jobtype properties" + e.getCause());
        }
        JobTypeManager jobTypeManager = this;
        synchronized (jobTypeManager) {
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            try {
                for (File dir : jobPluginsDir.listFiles()) {
                    if (!dir.isDirectory() || !dir.canRead()) continue;
                    try {
                        this.loadJob(dir, globalConf, globalSysConf);
                        Thread.currentThread().setContextClassLoader(prevCl);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to load jobtype " + dir.getName() + e.getMessage()));
                        throw new JobTypeManagerException(e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JobTypeManagerException(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new JobTypeManagerException(t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
    }

    public static File findFilefromDir(File dir, String fn) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.getName().equals(fn)) continue;
                return f;
            }
        }
        return null;
    }

    private void loadJob(File dir, Props commonConf, Props commonSysConf) throws JobTypeManagerException {
        Props conf = null;
        Props sysConf = null;
        File confFile = JobTypeManager.findFilefromDir(dir, JOBTYPECONFFILE);
        File sysConfFile = JobTypeManager.findFilefromDir(dir, JOBTYPESYSCONFFILE);
        if (sysConfFile == null) {
            logger.info((Object)("No job type found in " + dir.getAbsolutePath()));
            return;
        }
        try {
            conf = confFile != null ? new Props(commonConf, confFile) : new Props(commonConf);
            sysConf = new Props(commonSysConf, sysConfFile);
            sysConf = PropsUtils.resolveProps(sysConf);
        }
        catch (Exception e) {
            throw new JobTypeManagerException("Failed to get jobtype properties" + e.getMessage());
        }
        sysConf.put("plugin.dir", dir.getAbsolutePath());
        String jobtypeName = dir.getName();
        String jobtypeClass = sysConf.get("jobtype.class");
        logger.info((Object)("Loading jobtype " + jobtypeName));
        ArrayList<URL> resources = new ArrayList<URL>();
        try {
            List<String> jobtypeLibDirs;
            logger.info((Object)"Adding global resources.");
            List<String> typeGlobalClassPath = sysConf.getStringList("jobtype.global.classpath", null, ",");
            if (typeGlobalClassPath != null) {
                for (String jar : typeGlobalClassPath) {
                    URL cpItem = new File(jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            logger.info((Object)"Adding type resources.");
            List<String> typeClassPath = sysConf.getStringList("jobtype.classpath", null, ",");
            if (typeClassPath != null) {
                for (String jar : typeClassPath) {
                    URL cpItem = new File(jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            if ((jobtypeLibDirs = sysConf.getStringList("jobtype.lib.dir", null, ",")) != null) {
                for (String libDir : jobtypeLibDirs) {
                    for (File f : new File(libDir).listFiles()) {
                        if (!f.getName().endsWith(".jar")) continue;
                        resources.add(f.toURI().toURL());
                        logger.info((Object)("adding to classpath " + f.toURI().toURL()));
                    }
                }
            }
            logger.info((Object)"Adding type override resources.");
            for (File f : dir.listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                resources.add(f.toURI().toURL());
                logger.info((Object)("adding to classpath " + f.toURI().toURL()));
            }
        }
        catch (MalformedURLException e) {
            throw new JobTypeManagerException(e);
        }
        URLClassLoader jobTypeLoader = new URLClassLoader(resources.toArray(new URL[resources.size()]), this.parentLoader);
        Class<?> clazz = null;
        try {
            clazz = jobTypeLoader.loadClass(jobtypeClass);
            this.jobToClass.put(jobtypeName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new JobTypeManagerException(e);
        }
        logger.info((Object)"Doing simple testing...");
        try {
            Props fakeSysProps = new Props(sysConf);
            Props fakeJobProps = new Props(conf);
            Job job = (Job)Utils.callConstructor(clazz, "dummy", fakeSysProps, fakeJobProps, logger);
        }
        catch (Exception e) {
            logger.info((Object)("Jobtype " + jobtypeName + " failed test!"), (Throwable)e);
            throw new JobExecutionException(e);
        }
        catch (Throwable t) {
            logger.info((Object)("Jobtype " + jobtypeName + " failed test!"), t);
            throw new JobExecutionException(t);
        }
        logger.info((Object)("Loaded jobtype " + jobtypeName + " " + jobtypeClass));
        if (conf != null) {
            this.jobtypeJobProps.put(jobtypeName, conf);
        }
        this.jobtypeSysProps.put(jobtypeName, sysConf);
    }

    public Job buildJobExecutor(String jobId, Props jobProps, Logger logger) throws JobTypeManagerException {
        Job job = null;
        try {
            String jobType = jobProps.getString("type");
            if (jobType == null || jobType.length() == 0) {
                throw new JobExecutionException(String.format("The 'type' parameter for job[%s] is null or empty", jobProps, logger));
            }
            logger.info((Object)("Building " + jobType + " job executor. "));
            Class<? extends Job> executorClass = this.jobToClass.get(jobType);
            if (executorClass == null) {
                throw new JobExecutionException(String.format("Job type '" + jobType + "' is unrecognized. Could not construct job[%s] of type[%s].", jobProps, jobType));
            }
            Props sysConf = this.jobtypeSysProps.get(jobType);
            Props jobConf = jobProps;
            if (this.jobtypeJobProps.containsKey(jobType)) {
                Props p = this.jobtypeJobProps.get(jobType);
                for (String k : p.getKeySet()) {
                    if (jobConf.containsKey(k)) continue;
                    jobConf.put(k, p.get(k));
                }
            }
            jobConf = PropsUtils.resolveProps(jobConf);
            sysConf = sysConf != null ? PropsUtils.resolveProps(sysConf) : new Props();
            job = (Job)Utils.callConstructor(executorClass, jobId, sysConf, jobConf, logger);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to build job executor for job " + jobId + e.getMessage()));
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, e);
        }
        catch (Throwable t) {
            logger.error((Object)("Failed to build job executor for job " + jobId + t.getMessage()), t);
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, t);
        }
        return job;
    }

    public void registerJobType(String typeName, Class<? extends Job> jobTypeClass) {
        this.jobToClass.put(typeName, jobTypeClass);
    }
}

