/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.executor.ExecutionOptions;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAgent;
import azkaban.trigger.TriggerStatus;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ScheduleManager
implements TriggerAgent {
    private static Logger logger = Logger.getLogger(ScheduleManager.class);
    public static final String triggerSource = "SimpleTimeTrigger";
    private final DateTimeFormatter _dateFormat = DateTimeFormat.forPattern((String)"MM-dd-yyyy HH:mm:ss:SSS");
    private ScheduleLoader loader;
    private Map<Integer, Schedule> scheduleIDMap = new LinkedHashMap<Integer, Schedule>();
    private Map<Pair<Integer, String>, Schedule> scheduleIdentityPairMap = new LinkedHashMap<Pair<Integer, String>, Schedule>();

    public ScheduleManager(ScheduleLoader loader) {
        this.loader = loader;
    }

    @Override
    public void start() throws ScheduleManagerException {
        List<Schedule> scheduleList = null;
        try {
            scheduleList = this.loader.loadSchedules();
        }
        catch (ScheduleManagerException e) {
            logger.error((Object)("Failed to load schedules" + e.getCause() + e.getMessage()));
            e.printStackTrace();
        }
        for (Schedule sched : scheduleList) {
            if (sched.getStatus().equals(TriggerStatus.EXPIRED.toString())) {
                this.onScheduleExpire(sched);
                continue;
            }
            this.internalSchedule(sched);
        }
    }

    public synchronized void updateLocal() throws ScheduleManagerException {
        List<Schedule> updates = this.loader.loadUpdatedSchedules();
        for (Schedule s : updates) {
            if (s.getStatus().equals(TriggerStatus.EXPIRED.toString())) {
                this.onScheduleExpire(s);
                continue;
            }
            this.internalSchedule(s);
        }
    }

    private void onScheduleExpire(Schedule s) {
        this.removeSchedule(s);
    }

    @Override
    public void shutdown() {
    }

    public synchronized List<Schedule> getSchedules() throws ScheduleManagerException {
        this.updateLocal();
        return new ArrayList<Schedule>(this.scheduleIDMap.values());
    }

    public Schedule getSchedule(int projectId, String flowId) throws ScheduleManagerException {
        this.updateLocal();
        return this.scheduleIdentityPairMap.get(new Pair<Integer, String>(projectId, flowId));
    }

    public Schedule getSchedule(int scheduleId) throws ScheduleManagerException {
        this.updateLocal();
        return this.scheduleIDMap.get(scheduleId);
    }

    public synchronized void removeSchedule(int projectId, String flowId) throws ScheduleManagerException {
        Schedule sched = this.getSchedule(projectId, flowId);
        if (sched != null) {
            this.removeSchedule(sched);
        }
    }

    public synchronized void removeSchedule(Schedule sched) {
        Pair<Integer, String> identityPairMap = sched.getScheduleIdentityPair();
        Schedule schedule = this.scheduleIdentityPairMap.get(identityPairMap);
        if (schedule != null) {
            this.scheduleIdentityPairMap.remove(identityPairMap);
        }
        this.scheduleIDMap.remove(sched.getScheduleId());
        try {
            this.loader.removeSchedule(sched);
        }
        catch (ScheduleManagerException e) {
            e.printStackTrace();
        }
    }

    public Schedule scheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser) {
        return this.scheduleFlow(scheduleId, projectId, projectName, flowName, status, firstSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser, null, null);
    }

    public Schedule scheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions execOptions, List<SlaOption> slaOptions) {
        Schedule sched = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser, execOptions, slaOptions);
        logger.info((Object)("Scheduling flow '" + sched.getScheduleName() + "' for " + this._dateFormat.print(firstSchedTime) + " with a period of " + period == null ? "(non-recurring)" : period));
        this.insertSchedule(sched);
        return sched;
    }

    private synchronized void internalSchedule(Schedule s) {
        this.scheduleIDMap.put(s.getScheduleId(), s);
        this.scheduleIdentityPairMap.put(s.getScheduleIdentityPair(), s);
    }

    public synchronized void insertSchedule(Schedule s) {
        block5: {
            Schedule exist = this.scheduleIdentityPairMap.get(s.getScheduleIdentityPair());
            if (s.updateTime()) {
                try {
                    if (exist == null) {
                        this.loader.insertSchedule(s);
                        this.internalSchedule(s);
                        break block5;
                    }
                    s.setScheduleId(exist.getScheduleId());
                    this.loader.updateSchedule(s);
                    this.internalSchedule(s);
                }
                catch (ScheduleManagerException e) {
                    e.printStackTrace();
                }
            } else {
                logger.error((Object)("The provided schedule is non-recurring and the scheduled time already passed. " + s.getScheduleName()));
            }
        }
    }

    @Override
    public void loadTriggerFromProps(Props props) throws ScheduleManagerException {
        throw new ScheduleManagerException("create " + this.getTriggerSource() + " from json not supported yet");
    }

    @Override
    public String getTriggerSource() {
        return triggerSource;
    }
}

