/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp;

import azkaban.alert.Alerter;
import azkaban.database.AzkabanDatabaseSetup;
import azkaban.executor.ExecutorManager;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.jmx.JmxExecutorManager;
import azkaban.jmx.JmxJettyServer;
import azkaban.jmx.JmxTriggerManager;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.ProjectManager;
import azkaban.scheduler.ScheduleManager;
import azkaban.scheduler.TriggerBasedScheduleLoader;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.CreateTriggerAction;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.trigger.builtin.ExecutionChecker;
import azkaban.trigger.builtin.KillExecutionAction;
import azkaban.trigger.builtin.SlaAlertAction;
import azkaban.trigger.builtin.SlaChecker;
import azkaban.user.UserManager;
import azkaban.user.XmlUserManager;
import azkaban.utils.Emailer;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import azkaban.webapp.AzkabanServer;
import azkaban.webapp.plugin.PluginRegistry;
import azkaban.webapp.plugin.TriggerPlugin;
import azkaban.webapp.plugin.ViewerPlugin;
import azkaban.webapp.servlet.AbstractAzkabanServlet;
import azkaban.webapp.servlet.ExecutorServlet;
import azkaban.webapp.servlet.HistoryServlet;
import azkaban.webapp.servlet.IndexRedirectServlet;
import azkaban.webapp.servlet.JMXHttpServlet;
import azkaban.webapp.servlet.ProjectManagerServlet;
import azkaban.webapp.servlet.ProjectServlet;
import azkaban.webapp.servlet.ScheduleServlet;
import azkaban.webapp.servlet.TriggerManagerServlet;
import azkaban.webapp.session.SessionCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.Log4JLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.JarResourceLoader;
import org.joda.time.DateTimeZone;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class AzkabanWebServer
extends AzkabanServer {
    private static final Logger logger = Logger.getLogger(AzkabanWebServer.class);
    public static final String AZKABAN_HOME = "AZKABAN_HOME";
    public static final String DEFAULT_CONF_PATH = "conf";
    public static final String AZKABAN_PROPERTIES_FILE = "azkaban.properties";
    public static final String AZKABAN_PRIVATE_PROPERTIES_FILE = "azkaban.private.properties";
    private static final int MAX_FORM_CONTENT_SIZE = 0xA00000;
    private static final int MAX_HEADER_BUFFER_SIZE = 0xA00000;
    private static AzkabanWebServer app;
    private static final String DEFAULT_TIMEZONE_ID = "default.timezone.id";
    private static final int DEFAULT_PORT_NUMBER = 8081;
    private static final int DEFAULT_SSL_PORT_NUMBER = 8443;
    private static final int DEFAULT_THREAD_NUMBER = 20;
    private static final String VELOCITY_DEV_MODE_PARAM = "velocity.dev.mode";
    private static final String USER_MANAGER_CLASS_PARAM = "user.manager.class";
    private static final String DEFAULT_STATIC_DIR = "";
    private final VelocityEngine velocityEngine;
    private final Server server;
    private UserManager userManager;
    private ProjectManager projectManager;
    private ExecutorManager executorManager;
    private ScheduleManager scheduleManager;
    private TriggerManager triggerManager;
    private Map<String, Alerter> alerters;
    private final ClassLoader baseClassLoader;
    private Props props;
    private SessionCache sessionCache;
    private File tempDir;
    private Map<String, TriggerPlugin> triggerPlugins;
    private MBeanServer mbeanServer;
    private ArrayList<ObjectName> registeredMBeans = new ArrayList();

    public AzkabanWebServer() throws Exception {
        this(null, AzkabanWebServer.loadConfigurationFromAzkabanHome());
    }

    public AzkabanWebServer(Server server, Props props) throws Exception {
        this.props = props;
        this.server = server;
        this.velocityEngine = this.configureVelocityEngine(props.getBoolean(VELOCITY_DEV_MODE_PARAM, false));
        this.sessionCache = new SessionCache(props);
        this.userManager = this.loadUserManager(props);
        this.alerters = this.loadAlerters(props);
        this.executorManager = this.loadExecutorManager(props);
        this.projectManager = this.loadProjectManager(props);
        this.triggerManager = this.loadTriggerManager(props);
        this.loadBuiltinCheckersAndActions();
        this.scheduleManager = this.loadScheduleManager(this.triggerManager, props);
        String triggerPluginDir = props.getString("trigger.plugin.dir", "plugins/triggers");
        this.loadPluginCheckersAndActions(triggerPluginDir);
        this.baseClassLoader = this.getClassLoader();
        this.tempDir = new File(props.getString("azkaban.temp.dir", "temp"));
        if (props.containsKey(DEFAULT_TIMEZONE_ID)) {
            String timezone = props.getString(DEFAULT_TIMEZONE_ID);
            System.setProperty("user.timezone", timezone);
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)timezone));
            logger.info((Object)("Setting timezone to " + timezone));
        }
        this.configureMBeanServer();
    }

    private void setTriggerPlugins(Map<String, TriggerPlugin> triggerPlugins) {
        this.triggerPlugins = triggerPlugins;
    }

    private UserManager loadUserManager(Props props) {
        Class<?> userManagerClass = props.getClass(USER_MANAGER_CLASS_PARAM, null);
        logger.info((Object)("Loading user manager class " + userManagerClass.getName()));
        UserManager manager = null;
        if (userManagerClass != null && userManagerClass.getConstructors().length > 0) {
            try {
                Constructor<?> userManagerConstructor = userManagerClass.getConstructor(Props.class);
                manager = (UserManager)userManagerConstructor.newInstance(props);
            }
            catch (Exception e) {
                logger.error((Object)("Could not instantiate UserManager " + userManagerClass.getName()));
                throw new RuntimeException(e);
            }
        } else {
            manager = new XmlUserManager(props);
        }
        return manager;
    }

    private ProjectManager loadProjectManager(Props props) {
        logger.info((Object)"Loading JDBC for project management");
        JdbcProjectLoader loader = new JdbcProjectLoader(props);
        ProjectManager manager = new ProjectManager(loader, props);
        return manager;
    }

    private ExecutorManager loadExecutorManager(Props props) throws Exception {
        JdbcExecutorLoader loader = new JdbcExecutorLoader(props);
        ExecutorManager execManager = new ExecutorManager(props, loader, this.alerters);
        return execManager;
    }

    private ScheduleManager loadScheduleManager(TriggerManager tm, Props props) throws Exception {
        logger.info((Object)"Loading trigger based scheduler");
        TriggerBasedScheduleLoader loader = new TriggerBasedScheduleLoader(tm, "SimpleTimeTrigger");
        return new ScheduleManager(loader);
    }

    private TriggerManager loadTriggerManager(Props props) throws TriggerManagerException {
        JdbcTriggerLoader loader = new JdbcTriggerLoader(props);
        return new TriggerManager(props, loader, this.executorManager);
    }

    private void loadBuiltinCheckersAndActions() {
        logger.info((Object)"Loading built-in checker and action types");
        if (this.triggerManager instanceof TriggerManager) {
            SlaChecker.setExecutorManager(this.executorManager);
            ExecuteFlowAction.setExecutorManager(this.executorManager);
            ExecuteFlowAction.setProjectManager(this.projectManager);
            ExecuteFlowAction.setTriggerManager(this.triggerManager);
            KillExecutionAction.setExecutorManager(this.executorManager);
            SlaAlertAction.setExecutorManager(this.executorManager);
            SlaAlertAction.setAlerters(this.alerters);
            SlaAlertAction.setExecutorManager(this.executorManager);
            CreateTriggerAction.setTriggerManager(this.triggerManager);
            ExecutionChecker.setExecutorManager(this.executorManager);
        }
        this.triggerManager.registerCheckerType("BasicTimeChecker", BasicTimeChecker.class);
        this.triggerManager.registerCheckerType("SlaChecker", SlaChecker.class);
        this.triggerManager.registerCheckerType("ExecutionChecker", ExecutionChecker.class);
        this.triggerManager.registerActionType("ExecuteFlowAction", ExecuteFlowAction.class);
        this.triggerManager.registerActionType("KillExecutionAction", KillExecutionAction.class);
        this.triggerManager.registerActionType("AlertAction", SlaAlertAction.class);
        this.triggerManager.registerActionType("CreateTriggerAction", CreateTriggerAction.class);
    }

    private Map<String, Alerter> loadAlerters(Props props) {
        HashMap<String, Alerter> allAlerters = new HashMap<String, Alerter>();
        Emailer mailAlerter = new Emailer(props);
        allAlerters.put("email", mailAlerter);
        String pluginDir = props.getString("alerter.plugin.dir", "plugins/alerter");
        allAlerters.putAll(this.loadPluginAlerters(pluginDir));
        return allAlerters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Alerter> loadPluginAlerters(String pluginPath) {
        File alerterPluginPath = new File(pluginPath);
        if (!alerterPluginPath.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, Alerter> installedAlerterPlugins = new HashMap<String, Alerter>();
        ClassLoader parentLoader = this.getClass().getClassLoader();
        File[] pluginDirs = alerterPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] arr$ = pluginDirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block22: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block26: {
                    block24: {
                        File propertiesFile;
                        block25: {
                            block23: {
                                if (i$ >= len$) {
                                    return installedAlerterPlugins;
                                }
                                pluginDir = arr$[i$];
                                if (pluginDir.isDirectory()) break block23;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block22;
                            }
                            propertiesDir = new File(pluginDir, DEFAULT_CONF_PATH);
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block24;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block25;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, propertiesFile, propertiesOverrideFile) : PropsUtils.loadProps(null, propertiesFile);
                            break block26;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block22;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block22;
                }
                String pluginName = pluginProps.getString("alerter.name");
                List<String> extLibClasspath = pluginProps.getStringList("alerter.external.classpaths", (List<String>)null);
                String pluginClass = pluginProps.getString("alerter.class");
                if (pluginClass == null) {
                    logger.error((Object)"Alerter class is not set.");
                } else {
                    logger.info((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> alerterClass = null;
                    try {
                        alerterClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block22;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(alerterClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = alerterClass.getConstructor(Props.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block22;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginProps);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!(obj instanceof Alerter)) {
                        logger.error((Object)"The object is not an Alerter");
                    } else {
                        Alerter plugin = obj;
                        installedAlerterPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++i$;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPluginCheckersAndActions(String pluginPath) {
        logger.info((Object)"Loading plug-in checker and action types");
        File triggerPluginPath = new File(pluginPath);
        if (!triggerPluginPath.exists()) {
            logger.error((Object)("plugin path " + pluginPath + " doesn't exist!"));
            return;
        }
        ClassLoader parentLoader = this.getClassLoader();
        File[] pluginDirs = triggerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] arr$ = pluginDirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block20: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block25: {
                    block23: {
                        File propertiesFile;
                        block24: {
                            block22: {
                                block21: {
                                    if (i$ >= len$) {
                                        return;
                                    }
                                    pluginDir = arr$[i$];
                                    if (pluginDir.exists()) break block21;
                                    logger.error((Object)("Error! Trigger plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block20;
                                }
                                if (pluginDir.isDirectory()) break block22;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block20;
                            }
                            propertiesDir = new File(pluginDir, DEFAULT_CONF_PATH);
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block23;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block24;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, propertiesFile, propertiesOverrideFile) : PropsUtils.loadProps(null, propertiesFile);
                            break block25;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block20;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block20;
                }
                List<String> extLibClasspath = pluginProps.getStringList("trigger.external.classpaths", (List<String>)null);
                String pluginClass = pluginProps.getString("trigger.class");
                if (pluginClass == null) {
                    logger.error((Object)"Trigger class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> triggerClass = null;
                    try {
                        triggerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block20;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(triggerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    try {
                        Utils.invokeStaticMethod(urlClassLoader, pluginClass, "initiateCheckerTypes", pluginProps, app);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate checker types for " + pluginClass));
                        break block20;
                    }
                    try {
                        Utils.invokeStaticMethod(urlClassLoader, pluginClass, "initiateActionTypes", pluginProps, app);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Unable to initiate action types for " + pluginClass));
                    }
                }
            }
            ++i$;
        }
    }

    @Override
    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ExecutorManager getExecutorManager() {
        return this.executorManager;
    }

    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    private VelocityEngine configureVelocityEngine(boolean devMode) {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath, jar");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.setProperty("classpath.resource.loader.cache", (Object)(!devMode ? 1 : 0));
        engine.setProperty("classpath.resource.loader.modificationCheckInterval", (Object)5L);
        engine.setProperty("jar.resource.loader.class", (Object)JarResourceLoader.class.getName());
        engine.setProperty("jar.resource.loader.cache", (Object)(!devMode ? 1 : 0));
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("input.encoding", (Object)"UTF-8");
        engine.setProperty("output.encoding", (Object)"UTF-8");
        engine.setProperty("directive.set.null.allowed", (Object)true);
        engine.setProperty("resource.manager.logwhenfound", (Object)false);
        engine.setProperty("velocimacro.permissions.allow.inline", (Object)true);
        engine.setProperty("velocimacro.library.autoreload", (Object)devMode);
        engine.setProperty("velocimacro.library", (Object)"/azkaban/webapp/servlet/velocity/macros.vm");
        engine.setProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)true);
        engine.setProperty("velocimacro.arguments.strict", (Object)true);
        engine.setProperty("runtime.log.invalid.references", (Object)devMode);
        engine.setProperty("runtime.log.logsystem.class", Log4JLogChute.class);
        engine.setProperty("runtime.log.logsystem.log4j.logger", (Object)Logger.getLogger((String)"org.apache.velocity.Logger"));
        engine.setProperty("parser.pool.size", (Object)3);
        return engine;
    }

    public ClassLoader getClassLoader() {
        return this.baseClassLoader;
    }

    @Override
    public Props getServerProps() {
        return this.props;
    }

    public static void main(String[] args) throws Exception {
        boolean ssl;
        int port;
        logger.error((Object)"Starting Jetty Azkaban Executor...");
        Props azkabanSettings = AzkabanServer.loadProps(args);
        if (azkabanSettings == null) {
            logger.error((Object)"Azkaban Properties not loaded.");
            logger.error((Object)"Exiting Azkaban...");
            return;
        }
        int maxThreads = azkabanSettings.getInt("jetty.maxThreads", 20);
        final Server server = new Server();
        if (azkabanSettings.getBoolean("jetty.use.ssl", true)) {
            int sslPortNumber;
            port = sslPortNumber = azkabanSettings.getInt("jetty.ssl.port", 8443);
            ssl = true;
            logger.info((Object)("Setting up Jetty Https Server with port:" + sslPortNumber + " and numThreads:" + maxThreads));
            SslSocketConnector secureConnector = new SslSocketConnector();
            secureConnector.setPort(sslPortNumber);
            secureConnector.setKeystore(azkabanSettings.getString("jetty.keystore"));
            secureConnector.setPassword(azkabanSettings.getString("jetty.password"));
            secureConnector.setKeyPassword(azkabanSettings.getString("jetty.keypassword"));
            secureConnector.setTruststore(azkabanSettings.getString("jetty.truststore"));
            secureConnector.setTrustPassword(azkabanSettings.getString("jetty.trustpassword"));
            secureConnector.setHeaderBufferSize(0xA00000);
            server.addConnector((Connector)secureConnector);
        } else {
            ssl = false;
            port = azkabanSettings.getInt("jetty.port", 8081);
            SocketConnector connector = new SocketConnector();
            connector.setPort(port);
            connector.setHeaderBufferSize(0xA00000);
            server.addConnector((Connector)connector);
        }
        String hostname = azkabanSettings.getString("jetty.hostname", "localhost");
        azkabanSettings.put("server.hostname", hostname);
        azkabanSettings.put("server.port", port);
        azkabanSettings.put("server.useSSL", String.valueOf(ssl));
        app = new AzkabanWebServer(server, azkabanSettings);
        boolean checkDB = azkabanSettings.getBoolean("database.check.version", false);
        if (checkDB) {
            AzkabanDatabaseSetup setup = new AzkabanDatabaseSetup(azkabanSettings);
            setup.loadTableInfo();
            if (setup.needsUpdating()) {
                logger.error((Object)"Database is out of date.");
                setup.printUpgradePlan();
                logger.error((Object)"Exiting with error.");
                System.exit(-1);
            }
        }
        QueuedThreadPool httpThreadPool = new QueuedThreadPool(maxThreads);
        server.setThreadPool((ThreadPool)httpThreadPool);
        String staticDir = azkabanSettings.getString("web.resource.dir", DEFAULT_STATIC_DIR);
        logger.info((Object)("Setting up web resource dir " + staticDir));
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setMaxFormContentSize(0xA00000);
        String defaultServletPath = azkabanSettings.getString("azkaban.default.servlet.path", "/index");
        root.setResourceBase(staticDir);
        ServletHolder indexRedirect = new ServletHolder((Servlet)new IndexRedirectServlet(defaultServletPath));
        root.addServlet(indexRedirect, "/");
        ServletHolder index = new ServletHolder((Servlet)new ProjectServlet());
        root.addServlet(index, "/index");
        ServletHolder staticServlet = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(staticServlet, "/css/*");
        root.addServlet(staticServlet, "/js/*");
        root.addServlet(staticServlet, "/images/*");
        root.addServlet(staticServlet, "/fonts/*");
        root.addServlet(staticServlet, "/favicon.ico");
        root.addServlet(new ServletHolder((Servlet)new ProjectManagerServlet()), "/manager");
        root.addServlet(new ServletHolder((Servlet)new ExecutorServlet()), "/executor");
        root.addServlet(new ServletHolder((Servlet)new HistoryServlet()), "/history");
        root.addServlet(new ServletHolder((Servlet)new ScheduleServlet()), "/schedule");
        root.addServlet(new ServletHolder((Servlet)new JMXHttpServlet()), "/jmx");
        root.addServlet(new ServletHolder((Servlet)new TriggerManagerServlet()), "/triggers");
        String viewerPluginDir = azkabanSettings.getString("viewer.plugin.dir", "plugins/viewer");
        AzkabanWebServer.loadViewerPlugins(root, viewerPluginDir, app.getVelocityEngine());
        String triggerPluginDir = azkabanSettings.getString("trigger.plugin.dir", "plugins/triggers");
        Map<String, TriggerPlugin> triggerPlugins = AzkabanWebServer.loadTriggerPlugins(root, triggerPluginDir, app);
        app.setTriggerPlugins(triggerPlugins);
        app.getTriggerManager().start();
        root.setAttribute("azkaban_app", (Object)app);
        try {
            server.start();
        }
        catch (Exception e) {
            logger.warn((Object)e);
            Utils.croak(e.getMessage(), 1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info((Object)"Shutting down http server...");
                try {
                    app.close();
                    server.stop();
                    server.destroy();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while shutting down http server.", (Throwable)e);
                }
                logger.info((Object)"kk thx bye.");
            }
        });
        logger.info((Object)("Server running on " + (ssl ? "ssl" : DEFAULT_STATIC_DIR) + " port " + port + "."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, TriggerPlugin> loadTriggerPlugins(Context root, String pluginPath, AzkabanWebServer azkabanWebApp) {
        File triggerPluginPath = new File(pluginPath);
        if (!triggerPluginPath.exists()) {
            return new HashMap<String, TriggerPlugin>();
        }
        HashMap<String, TriggerPlugin> installedTriggerPlugins = new HashMap<String, TriggerPlugin>();
        ClassLoader parentLoader = AzkabanWebServer.class.getClassLoader();
        File[] pluginDirs = triggerPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] arr$ = pluginDirs;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block22: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block27: {
                    block25: {
                        File propertiesFile;
                        block26: {
                            block24: {
                                block23: {
                                    if (i$ >= len$) {
                                        String jarResourcePath = StringUtils.join(jarPaths, (String)", ");
                                        logger.info((Object)("Setting jar resource path " + jarResourcePath));
                                        VelocityEngine ve = azkabanWebApp.getVelocityEngine();
                                        ve.addProperty("jar.resource.loader.path", (Object)jarResourcePath);
                                        return installedTriggerPlugins;
                                    }
                                    pluginDir = arr$[i$];
                                    if (pluginDir.exists()) break block23;
                                    logger.error((Object)("Error! Trigger plugin path " + pluginDir.getPath() + " doesn't exist."));
                                    break block22;
                                }
                                if (pluginDir.isDirectory()) break block24;
                                logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                                break block22;
                            }
                            propertiesDir = new File(pluginDir, DEFAULT_CONF_PATH);
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block25;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block26;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, propertiesFile, propertiesOverrideFile) : PropsUtils.loadProps(null, propertiesFile);
                            break block27;
                        }
                        logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                        break block22;
                    }
                    logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                    break block22;
                }
                String pluginName = pluginProps.getString("trigger.name");
                List<String> extLibClasspath = pluginProps.getStringList("trigger.external.classpaths", (List<String>)null);
                String pluginClass = pluginProps.getString("trigger.class");
                if (pluginClass == null) {
                    logger.error((Object)"Trigger class is not set.");
                } else {
                    logger.error((Object)("Plugin class " + pluginClass));
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error((Object)("Library path " + propertiesDir + " not found."));
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> triggerClass = null;
                    try {
                        triggerClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)("Class " + pluginClass + " not found."));
                        break block22;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(triggerClass);
                    logger.info((Object)("Source jar " + source));
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = triggerClass.getConstructor(String.class, Props.class, Context.class, AzkabanWebServer.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error((Object)("Constructor not found in " + pluginClass));
                        break block22;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginName, pluginProps, root, azkabanWebApp);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (!(obj instanceof TriggerPlugin)) {
                        logger.error((Object)"The object is not an TriggerPlugin");
                    } else {
                        TriggerPlugin plugin = obj;
                        installedTriggerPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++i$;
        }
    }

    public Map<String, TriggerPlugin> getTriggerPlugins() {
        return this.triggerPlugins;
    }

    /*
     * Unable to fully structure code
     */
    private static void loadViewerPlugins(Context root, String pluginPath, VelocityEngine ve) {
        viewerPluginPath = new File(pluginPath);
        if (!viewerPluginPath.exists()) {
            return;
        }
        parentLoader = AzkabanWebServer.class.getClassLoader();
        pluginDirs = viewerPluginPath.listFiles();
        jarPaths = new ArrayList<String>();
        for (File pluginDir : pluginDirs) {
            if (!pluginDir.exists()) {
                AzkabanWebServer.logger.error((Object)("Error viewer plugin path " + pluginDir.getPath() + " doesn't exist."));
                continue;
            }
            if (!pluginDir.isDirectory()) {
                AzkabanWebServer.logger.error((Object)("The plugin path " + pluginDir + " is not a directory."));
                continue;
            }
            propertiesDir = new File(pluginDir, "conf");
            pluginProps = null;
            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) ** GOTO lbl24
            propertiesFile = new File(propertiesDir, "plugin.properties");
            propertiesOverrideFile = new File(propertiesDir, "override.properties");
            if (propertiesFile.exists()) {
                pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, new File[]{propertiesFile});
            } else {
                AzkabanWebServer.logger.error((Object)("Plugin conf file " + propertiesFile + " not found."));
                continue;
lbl24:
                // 1 sources

                AzkabanWebServer.logger.error((Object)("Plugin conf path " + propertiesDir + " not found."));
                continue;
            }
            pluginName = pluginProps.getString("viewer.name");
            pluginWebPath = pluginProps.getString("viewer.path");
            pluginJobTypes = pluginProps.getString("viewer.jobtypes", null);
            pluginOrder = pluginProps.getInt("viewer.order", 0);
            pluginHidden = pluginProps.getBoolean("viewer.hidden", false);
            extLibClasspath = pluginProps.getStringList("viewer.external.classpaths", (List<String>)null);
            pluginClass = pluginProps.getString("viewer.servlet.class");
            if (pluginClass == null) {
                AzkabanWebServer.logger.error((Object)"Viewer class is not set.");
            } else {
                AzkabanWebServer.logger.error((Object)("Plugin class " + pluginClass));
            }
            urlClassLoader = null;
            libDir = new File(pluginDir, "lib");
            if (libDir.exists() && libDir.isDirectory()) {
                files = libDir.listFiles();
                urls = new ArrayList<URL>();
                for (i = 0; i < files.length; ++i) {
                    try {
                        url = files[i].toURI().toURL();
                        urls.add(url);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        AzkabanWebServer.logger.error((Object)e);
                    }
                }
                if (extLibClasspath != null) {
                    for (String extLib : extLibClasspath) {
                        extLibFile = new File(pluginDir, extLib);
                        if (extLibFile.exists()) {
                            if (extLibFile.isDirectory()) {
                                extLibFiles = extLibFile.listFiles();
                                for (i = 0; i < extLibFiles.length; ++i) {
                                    try {
                                        url = extLibFiles[i].toURI().toURL();
                                        urls.add(url);
                                        continue;
                                    }
                                    catch (MalformedURLException e) {
                                        AzkabanWebServer.logger.error((Object)e);
                                    }
                                }
                                continue;
                            }
                            try {
                                url = extLibFile.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                AzkabanWebServer.logger.error((Object)e);
                            }
                            continue;
                        }
                        AzkabanWebServer.logger.error((Object)("External library path " + extLibFile.getAbsolutePath() + " not found."));
                    }
                }
            } else {
                AzkabanWebServer.logger.error((Object)("Library path " + libDir.getAbsolutePath() + " not found."));
                continue;
            }
            urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
            viewerClass = null;
            try {
                viewerClass = urlClassLoader.loadClass(pluginClass);
            }
            catch (ClassNotFoundException e) {
                AzkabanWebServer.logger.error((Object)("Class " + pluginClass + " not found."));
                continue;
            }
            source = FileIOUtils.getSourcePathFromClass(viewerClass);
            AzkabanWebServer.logger.info((Object)("Source jar " + source));
            jarPaths.add("jar:file:" + source);
            constructor = null;
            try {
                constructor = viewerClass.getConstructor(new Class[]{Props.class});
            }
            catch (NoSuchMethodException e) {
                AzkabanWebServer.logger.error((Object)("Constructor not found in " + pluginClass));
                continue;
            }
            obj = null;
            try {
                obj = constructor.newInstance(new Object[]{pluginProps});
            }
            catch (Exception e) {
                AzkabanWebServer.logger.error((Object)e);
                AzkabanWebServer.logger.error((Object)e.getCause());
            }
            if (!(obj instanceof AbstractAzkabanServlet)) {
                AzkabanWebServer.logger.error((Object)"The object is not an AbstractAzkabanServlet");
                continue;
            }
            avServlet = obj;
            root.addServlet(new ServletHolder((Servlet)avServlet), "/" + pluginWebPath + "/*");
            PluginRegistry.getRegistry().register(new ViewerPlugin(pluginName, pluginWebPath, pluginOrder, pluginHidden, pluginJobTypes));
        }
        jarResourcePath = StringUtils.join(jarPaths, (String)", ");
        AzkabanWebServer.logger.info((Object)("Setting jar resource path " + jarResourcePath));
        ve.addProperty("jar.resource.loader.path", (Object)jarResourcePath);
    }

    private static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv(AZKABAN_HOME);
        if (azkabanHome == null) {
            logger.error((Object)"AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error((Object)(azkabanHome + " is not a readable directory."));
            return null;
        }
        File confPath = new File(azkabanHome, DEFAULT_CONF_PATH);
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error((Object)(azkabanHome + " does not contain a readable conf directory."));
            return null;
        }
        return AzkabanWebServer.loadAzkabanConfigurationFromDirectory(confPath);
    }

    public File getTempDirectory() {
        return this.tempDir;
    }

    private static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, AZKABAN_PRIVATE_PROPERTIES_FILE);
        File azkabanPropsFile = new File(dir, AZKABAN_PROPERTIES_FILE);
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info((Object)"Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info((Object)"Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private void configureMBeanServer() {
        logger.info((Object)"Registering MBeans...");
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerMbean("jetty", new JmxJettyServer(this.server));
        this.registerMbean("triggerManager", new JmxTriggerManager(this.triggerManager));
        if (this.executorManager instanceof ExecutorManager) {
            this.registerMbean("executorManager", new JmxExecutorManager(this.executorManager));
        }
    }

    public void close() {
        try {
            for (ObjectName name : this.registeredMBeans) {
                this.mbeanServer.unregisterMBean(name);
                logger.info((Object)("Jmx MBean " + name.getCanonicalName() + " unregistered."));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to cleanup MBeanServer", (Throwable)e);
        }
        this.scheduleManager.shutdown();
        this.executorManager.shutdown();
    }

    private void registerMbean(String name, Object mbean) {
        Class<?> mbeanClass = mbean.getClass();
        try {
            ObjectName mbeanName = new ObjectName(mbeanClass.getName() + ":name=" + name);
            this.mbeanServer.registerMBean(mbean, mbeanName);
            logger.info((Object)("Bean " + mbeanClass.getCanonicalName() + " registered."));
            this.registeredMBeans.add(mbeanName);
        }
        catch (Exception e) {
            logger.error((Object)("Error registering mbean " + mbeanClass.getCanonicalName()), (Throwable)e);
        }
    }

    public List<ObjectName> getMbeanNames() {
        return this.registeredMBeans;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this.mbeanServer.getMBeanInfo(name);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public Object getMBeanAttribute(ObjectName name, String attribute) {
        try {
            return this.mbeanServer.getAttribute(name, attribute);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }
}

