/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.codec.StreamCodec;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.type.RecordWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncryptedSerializedRecordToSerializedRecordConverterBase
extends Converter<String, String, RecordWithMetadata<byte[]>, RecordWithMetadata<byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(EncryptedSerializedRecordToSerializedRecordConverterBase.class);
    private StreamCodec decryptor;

    public Converter<String, String, RecordWithMetadata<byte[]>, RecordWithMetadata<byte[]>> init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.decryptor = this.buildDecryptor(workUnit);
        return this;
    }

    protected abstract StreamCodec buildDecryptor(WorkUnitState var1);

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return "";
    }

    public Iterable<RecordWithMetadata<byte[]>> convertRecord(String outputSchema, RecordWithMetadata<byte[]> inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            byte[] decryptedBytes;
            ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])inputRecord.getRecord());
            try (InputStream decryptedInputStream = this.decryptor.decodeInputStream((InputStream)inputStream);){
                decryptedBytes = IOUtils.toByteArray((InputStream)decryptedInputStream);
            }
            inputRecord.getMetadata().getGlobalMetadata().addTransferEncoding(this.decryptor.getTag());
            RecordWithMetadata serializedRecord = new RecordWithMetadata((Object)decryptedBytes, inputRecord.getMetadata());
            return Collections.singleton(serializedRecord);
        }
        catch (Exception e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

