/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util.degrader;

import com.linkedin.common.stats.LongStats;
import com.linkedin.common.stats.LongTracking;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.degrader.CallCompletion;
import com.linkedin.util.degrader.CallTracker;
import com.linkedin.util.degrader.ErrorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class CallTrackerImpl
implements CallTracker {
    private static final Clock DEFAULT_CLOCK = SystemClock.instance();
    private final Object _lock = new Object();
    private final Clock _clock;
    private final long _interval;
    private final Tracker _tracker;
    private volatile long _lastStartTime;
    private volatile long _lastResetTime;
    private long _callCountTotal;
    private long _callStartCountTotal;
    private long _errorCountTotal;
    private int _concurrency;
    private long _sumOfOutstandingStartTimes;
    private Map<ErrorType, Integer> _errorTypeCountsTotal;
    private Pending _pending = null;
    private volatile List<CallTracker.StatsRolloverEventListener> _listeners = new ArrayList<CallTracker.StatsRolloverEventListener>();

    public CallTrackerImpl(long interval) {
        this(interval, DEFAULT_CLOCK);
    }

    public CallTrackerImpl(long interval, Clock clock) {
        this._clock = clock;
        this._interval = interval;
        this._lastStartTime = -1L;
        this._lastResetTime = this._clock.currentTimeMillis();
        this._errorTypeCountsTotal = new HashMap<ErrorType, Integer>();
        this._tracker = new Tracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallCompletion startCall() {
        Pending pending;
        long currentTime;
        Object object = this._lock;
        synchronized (object) {
            currentTime = this._clock.currentTimeMillis();
            this._tracker.getStatsWithCurrentTime(currentTime);
            ++this._callStartCountTotal;
            this._tracker._callStartCount++;
            ++this._concurrency;
            if (this._concurrency > this._tracker._concurrentMax) {
                this._tracker._concurrentMax = this._concurrency;
            }
            this._lastStartTime = currentTime;
            this._sumOfOutstandingStartTimes += currentTime;
            pending = this.checkForPending();
        }
        if (pending != null) {
            pending.deliver();
        }
        return new CallCompletionImpl(currentTime);
    }

    @Override
    public CallTracker.CallStats getCallStats() {
        return this.getStatsWithCurrentTime(this._clock.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallTracker.CallStats getStatsWithCurrentTime(long currentTimeMillis) {
        CallTracker.CallStats stats = this._tracker.getMostRecentStats();
        if (stats.stale(currentTimeMillis)) {
            Pending pending;
            Object object = this._lock;
            synchronized (object) {
                stats = this._tracker.getStatsWithCurrentTime(currentTimeMillis);
                pending = this.checkForPending();
            }
            if (pending != null) {
                pending.deliver();
            }
        }
        return stats;
    }

    @Override
    public long getInterval() {
        return this._interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatsRolloverEventListener(CallTracker.StatsRolloverEventListener listener) {
        Object object = this._lock;
        synchronized (object) {
            ArrayList<CallTracker.StatsRolloverEventListener> copy = new ArrayList<CallTracker.StatsRolloverEventListener>(this._listeners);
            copy.add(listener);
            this._listeners = Collections.unmodifiableList(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeStatsRolloverEventListener(CallTracker.StatsRolloverEventListener listener) {
        boolean removed = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._listeners.contains(listener)) {
                ArrayList<CallTracker.StatsRolloverEventListener> copy = new ArrayList<CallTracker.StatsRolloverEventListener>(this._listeners);
                removed = copy.remove(listener);
                this._listeners = Collections.unmodifiableList(copy);
            }
        }
        return removed;
    }

    @Override
    public long getCurrentCallCountTotal() {
        return this._callCountTotal;
    }

    @Override
    public long getCurrentCallStartCountTotal() {
        return this._callStartCountTotal;
    }

    @Override
    public long getCurrentErrorCountTotal() {
        return this._errorCountTotal;
    }

    @Override
    public Map<ErrorType, Integer> getCurrentErrorTypeCountsTotal() {
        return Collections.unmodifiableMap(new HashMap<ErrorType, Integer>(this._errorTypeCountsTotal));
    }

    @Override
    public int getCurrentConcurrency() {
        return this._concurrency;
    }

    @Override
    public long getTimeSinceLastCallStart() {
        long lastStartTime = this._lastStartTime;
        return lastStartTime == -1L ? -1L : this._clock.currentTimeMillis() - lastStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Pending pending;
        Object object = this._lock;
        synchronized (object) {
            this._lastStartTime = -1L;
            this._lastResetTime = this._clock.currentTimeMillis();
            this._callCountTotal = 0L;
            this._callStartCountTotal = 0L;
            this._errorCountTotal = 0L;
            this._tracker.reset();
            this._errorTypeCountsTotal.clear();
            pending = this.checkForPending();
        }
        if (pending != null) {
            pending.deliver();
        }
    }

    private void addPending(CallTracker.CallStats stats, boolean reset) {
        if (!this._listeners.isEmpty()) {
            if (this._pending == null) {
                this._pending = new Pending(this._listeners);
            }
            this._pending.add(stats, reset);
        }
    }

    private Pending checkForPending() {
        if (this._pending == null) {
            return null;
        }
        Pending pending = this._pending;
        this._pending = null;
        return pending;
    }

    @Override
    public long getLastResetTime() {
        return this._lastResetTime;
    }

    private void addCallData(long duration, boolean hasError, long currentTime, ErrorType errorType) {
        this._tracker.addNewData(currentTime, hasError, duration, errorType);
        if (hasError) {
            ++this._errorCountTotal;
            if (errorType != null) {
                Integer count = this._errorTypeCountsTotal.get((Object)errorType);
                if (count == null) {
                    this._errorTypeCountsTotal.put(errorType, 1);
                } else {
                    this._errorTypeCountsTotal.put(errorType, count + 1);
                }
            }
        }
        ++this._callCountTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackCall(long duration, boolean hasError) {
        Pending pending;
        Object object = this._lock;
        synchronized (object) {
            this.addCallData(duration, hasError, this._clock.currentTimeMillis(), null);
            pending = this.checkForPending();
        }
        if (pending != null) {
            pending.deliver();
        }
    }

    @Override
    public void trackCall(long duration) {
        this.trackCall(duration, false);
    }

    @Override
    public void trackCallWithError(long duration) {
        this.trackCall(duration, true);
    }

    public static class CallTrackerStats
    implements CallTracker.CallStats {
        private final long _intervalConfigured;
        private final long _intervalStartTime;
        private final long _intervalEndTime;
        private final long _callCountTotal;
        private final int _callStartCount;
        private final long _callStartCountTotal;
        private final int _errorCount;
        private final long _errorCountTotal;
        private final int _concurrentMax;
        private final long _outstandingStartTimeAvg;
        private final int _outstandingCount;
        private final LongStats _callTimeStats;
        private final Map<ErrorType, Integer> _errorTypeCounts;
        private final Map<ErrorType, Integer> _errorTypeCountsTotal;

        public CallTrackerStats() {
            this(0L);
        }

        public CallTrackerStats(long intervalConfigured) {
            this._intervalConfigured = intervalConfigured;
            this._intervalStartTime = 0L;
            this._intervalEndTime = 0L;
            this._callCountTotal = 0L;
            this._callStartCount = 0;
            this._callStartCountTotal = 0L;
            this._errorCount = 0;
            this._errorCountTotal = 0L;
            this._concurrentMax = 0;
            this._outstandingStartTimeAvg = 0L;
            this._outstandingCount = 0;
            this._callTimeStats = new LongStats();
            this._errorTypeCounts = Collections.emptyMap();
            this._errorTypeCountsTotal = Collections.emptyMap();
        }

        public CallTrackerStats(long intervalConfigured, long intervalStartTime, long intervalEndTime, long callCountTotal, int callStartCount, long callStartCountTotal, int errorCount, long errorCountTotal, int concurrentMax, long outstandingStartTimeAvg, int outstandingCount, LongStats callTimeStats, Map<ErrorType, Integer> errorTypeCounts, Map<ErrorType, Integer> errorTypeCountsTotal) {
            this._intervalConfigured = intervalConfigured;
            this._intervalStartTime = intervalStartTime;
            this._intervalEndTime = intervalEndTime;
            this._callCountTotal = callCountTotal;
            this._callStartCount = callStartCount;
            this._callStartCountTotal = callStartCountTotal;
            this._errorCount = errorCount;
            this._errorCountTotal = errorCountTotal;
            this._concurrentMax = concurrentMax;
            this._outstandingStartTimeAvg = outstandingStartTimeAvg;
            this._outstandingCount = outstandingCount;
            this._callTimeStats = callTimeStats;
            this._errorTypeCounts = Collections.unmodifiableMap(new HashMap<ErrorType, Integer>(errorTypeCounts));
            this._errorTypeCountsTotal = Collections.unmodifiableMap(new HashMap<ErrorType, Integer>(errorTypeCountsTotal));
        }

        @Override
        public Map<ErrorType, Integer> getErrorTypeCounts() {
            return this._errorTypeCounts;
        }

        @Override
        public Map<ErrorType, Integer> getErrorTypeCountsTotal() {
            return this._errorTypeCountsTotal;
        }

        @Override
        public boolean stale(long currentTimeMillis) {
            return currentTimeMillis >= this._intervalEndTime + this._intervalConfigured;
        }

        @Override
        public long getIntervalStartTime() {
            return this._intervalStartTime;
        }

        @Override
        public long getIntervalEndTime() {
            return this._intervalEndTime;
        }

        @Override
        public long getInterval() {
            long interval = this._intervalEndTime - this._intervalStartTime;
            return interval < 0L ? 0L : interval;
        }

        @Override
        public int getCallCount() {
            return this._callTimeStats.getCount();
        }

        @Override
        public long getCallCountTotal() {
            return this._callCountTotal;
        }

        @Override
        public int getCallStartCount() {
            return this._callStartCount;
        }

        @Override
        public long getCallStartCountTotal() {
            return this._callStartCountTotal;
        }

        @Override
        public double getCallsPerSecond() {
            return CallTrackerStats.safeDivide(this.getCallCount(), (double)this.getInterval() / 1000.0);
        }

        @Override
        public int getErrorCount() {
            return this._errorCount;
        }

        @Override
        public long getErrorCountTotal() {
            return this._errorCountTotal;
        }

        @Override
        public double getErrorRate() {
            return CallTrackerStats.safeDivide(this._errorCount, this.getCallCount());
        }

        @Override
        public int getConcurrentMax() {
            return this._concurrentMax;
        }

        @Override
        public long getOutstandingStartTimeAvg() {
            return this._outstandingCount > 0 ? this._intervalEndTime - this._outstandingStartTimeAvg : 0L;
        }

        @Override
        public int getOutstandingCount() {
            return this._outstandingCount;
        }

        @Override
        public LongStats getCallTimeStats() {
            return this._callTimeStats;
        }

        private static double safeDivide(double numerator, double denominator) {
            return denominator != 0.0 ? numerator / denominator : 0.0;
        }

        public String toString() {
            LongStats callTimeStats = this.getCallTimeStats();
            return "EndTime=" + this.getIntervalEndTime() + ", Interval=" + this.getInterval() + ", CallCount=" + this.getCallCount() + ", CallCountTotal=" + this.getCallCountTotal() + ", CallStartCountTotal=" + this.getCallStartCountTotal() + ", CallsPerSecond=" + this.getCallsPerSecond() + ", ErrorCount=" + this.getErrorCount() + ", ErrorCountTotal=" + this.getErrorCountTotal() + ", ErrorRate=" + this.getErrorRate() + ", ConcurrentMax=" + this.getConcurrentMax() + ", OutstandingStartTimeAvg=" + this.getOutstandingStartTimeAvg() + ", OutstandingCount=" + this.getOutstandingCount() + ", CallTimeAvg=" + callTimeStats.getAverage() + ", CallTimeStdDev=" + callTimeStats.getStandardDeviation() + ", CallTimeMin=" + callTimeStats.getMinimum() + ", CallTimeMax=" + callTimeStats.getMaximum() + ", CallTime50Pct=" + callTimeStats.get50Pct() + ", CallTime90Pct=" + callTimeStats.get90Pct() + ", CallTime95Pct=" + callTimeStats.get95Pct() + ", CallTime99Pct=" + callTimeStats.get99Pct() + ", ErrorTypeCounts=" + this.getErrorTypeCounts() + ", ErrorTypeCountsTotal=" + this.getErrorTypeCountsTotal();
        }
    }

    private static class Pending {
        private final List<PendingEvent> _pendingEvents = new ArrayList<PendingEvent>(4);
        private final List<CallTracker.StatsRolloverEventListener> _listeners;

        private Pending(List<CallTracker.StatsRolloverEventListener> listeners) {
            this._listeners = listeners;
        }

        private void add(CallTracker.CallStats stats, boolean reset) {
            this._pendingEvents.add(new PendingEvent(stats, reset));
        }

        private void deliver() {
            for (PendingEvent event : this._pendingEvents) {
                for (CallTracker.StatsRolloverEventListener listener : this._listeners) {
                    listener.onStatsRollover(event);
                }
            }
        }

        private static class PendingEvent
        implements CallTracker.StatsRolloverEvent {
            private final CallTracker.CallStats _stats;
            private final boolean _reset;

            PendingEvent(CallTracker.CallStats stats, boolean reset) {
                this._stats = stats;
                this._reset = reset;
            }

            @Override
            public CallTracker.CallStats getCallStats() {
                return this._stats;
            }

            @Override
            public boolean isReset() {
                return this._reset;
            }
        }
    }

    private class Tracker {
        private volatile CallTracker.CallStats _stats;
        private long _startTime;
        private int _callStartCount;
        private int _errorCount;
        private int _concurrentMax;
        private final LongTracking _callTimeTracking = new LongTracking();
        private final Map<ErrorType, Integer> _errorTypeCounts = new HashMap<ErrorType, Integer>();

        private Tracker() {
            this.reset();
        }

        private void resetStats(long startTime) {
            this._startTime = startTime;
            this._callStartCount = 0;
            this._errorCount = 0;
            this._concurrentMax = CallTrackerImpl.this._concurrency;
            this._callTimeTracking.reset();
            this._errorTypeCounts.clear();
        }

        private void reset() {
            this.resetStats(CallTrackerImpl.this._lastResetTime - CallTrackerImpl.this._interval);
            this.rolloverStats(CallTrackerImpl.this._lastResetTime, true);
        }

        private void rolloverStats(long endTime, boolean reset) {
            this._stats = new CallTrackerStats(CallTrackerImpl.this._interval, this._startTime, endTime, CallTrackerImpl.this._callCountTotal, this._callStartCount, CallTrackerImpl.this._callStartCountTotal, this._errorCount, CallTrackerImpl.this._errorCountTotal, this._concurrentMax, CallTrackerImpl.this._concurrency == 0 ? 0L : CallTrackerImpl.this._sumOfOutstandingStartTimes / (long)CallTrackerImpl.this._concurrency, CallTrackerImpl.this._concurrency, this._callTimeTracking.getStats(), this._errorTypeCounts, CallTrackerImpl.this._errorTypeCountsTotal);
            this.resetStats(endTime);
            CallTrackerImpl.this.addPending(this._stats, reset);
        }

        private void addNewData(long currentTime, boolean hasError, long duration, ErrorType errorType) {
            this.getStatsWithCurrentTime(currentTime);
            this._callTimeTracking.addValue(duration);
            if (hasError) {
                ++this._errorCount;
            }
            if (errorType != null) {
                Integer count = this._errorTypeCounts.get((Object)errorType);
                if (count == null) {
                    this._errorTypeCounts.put(errorType, 1);
                } else {
                    this._errorTypeCounts.put(errorType, count + 1);
                }
            }
        }

        private CallTracker.CallStats getMostRecentStats() {
            return this._stats;
        }

        public CallTracker.CallStats getStatsWithCurrentTime(long currentTime) {
            if (this._stats.stale(currentTime)) {
                long offset = currentTime - CallTrackerImpl.this._lastResetTime;
                long currentStartOffset = offset / CallTrackerImpl.this._interval * CallTrackerImpl.this._interval;
                long lastEnd = CallTrackerImpl.this._lastResetTime + currentStartOffset;
                long lastStart = lastEnd - CallTrackerImpl.this._interval;
                if (this._startTime == lastStart) {
                    this.rolloverStats(lastEnd, false);
                } else if (this._startTime < lastStart) {
                    this.rolloverStats(this._startTime + CallTrackerImpl.this._interval, false);
                    this._startTime = lastStart;
                    this.rolloverStats(lastEnd, false);
                }
            }
            return this._stats;
        }
    }

    private class CallCompletionImpl
    implements CallCompletion {
        private final AtomicBoolean _done = new AtomicBoolean();
        private final long _start;
        private final AtomicLong _endTime = new AtomicLong(0L);

        private CallCompletionImpl(long currentTime) {
            this._start = currentTime;
        }

        @Override
        public void record() {
            this._endTime.compareAndSet(0L, CallTrackerImpl.this._clock.currentTimeMillis());
        }

        @Override
        public void endCall() {
            this.endCall(false, null);
        }

        @Override
        public void endCallWithError() {
            this.endCall(true, null);
        }

        @Override
        public void endCallWithError(ErrorType errorType) {
            this.endCall(true, errorType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endCall(boolean hasError, ErrorType errorType) {
            if (this._done.compareAndSet(false, true)) {
                Pending pending;
                Object object = CallTrackerImpl.this._lock;
                synchronized (object) {
                    this._endTime.compareAndSet(0L, CallTrackerImpl.this._clock.currentTimeMillis());
                    long duration = this._endTime.get() - this._start;
                    if (this._start >= CallTrackerImpl.this._lastResetTime) {
                        CallTrackerImpl.this.addCallData(duration, hasError, this._endTime.get(), errorType);
                    }
                    if (CallTrackerImpl.this._concurrency > 0) {
                        CallTrackerImpl.this._concurrency--;
                    }
                    CallTrackerImpl.this._sumOfOutstandingStartTimes = CallTrackerImpl.this._sumOfOutstandingStartTimes - this._start;
                    if (CallTrackerImpl.this._concurrency == 0 && CallTrackerImpl.this._sumOfOutstandingStartTimes != 0L) {
                        CallTrackerImpl.this._sumOfOutstandingStartTimes = 0L;
                    }
                    pending = CallTrackerImpl.this.checkForPending();
                }
                if (pending != null) {
                    pending.deliver();
                }
            }
        }
    }
}

