/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.gobblin.broker.SimpleScope;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.ScopeType;

public enum SimpleScopeType implements ScopeType<SimpleScopeType>
{
    GLOBAL("global", new SimpleScopeType[0]),
    LOCAL("local", GLOBAL);

    private static final Set<SimpleScopeType> LOCAL_SCOPES;
    private final List<SimpleScopeType> parentScopes;
    private final String defaultId;

    private SimpleScopeType(String defaultId, SimpleScopeType ... parentScopes) {
        this.defaultId = defaultId;
        this.parentScopes = Lists.newArrayList((Object[])parentScopes);
    }

    @Override
    public boolean isLocal() {
        return LOCAL_SCOPES.contains(this);
    }

    @Override
    public Collection<SimpleScopeType> parentScopes() {
        return this.parentScopes;
    }

    @Override
    @Nullable
    public ScopeInstance defaultScopeInstance() {
        return this.defaultId == null ? null : new SimpleScope<SimpleScopeType>(this, this.defaultId);
    }

    @Override
    public SimpleScopeType rootScope() {
        return GLOBAL;
    }

    private SimpleScopeType(List<SimpleScopeType> parentScopes, String defaultId) {
        this.parentScopes = parentScopes;
        this.defaultId = defaultId;
    }

    static {
        LOCAL_SCOPES = Sets.newHashSet((Object[])new SimpleScopeType[]{LOCAL});
    }
}

