/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import org.apache.gobblin.writer.PartitionIdentifier;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsWriterMetrics {
    private static final Logger log = LoggerFactory.getLogger(FsWriterMetrics.class);
    String writerId;
    PartitionIdentifier partitionInfo;
    Collection<FileInfo> fileInfos;

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (IOException e) {
            log.error("IOException serializing FsWriterMetrics as JSON! Returning no metrics", (Throwable)e);
            return "{}";
        }
    }

    public static FsWriterMetrics fromJson(String in) throws IOException {
        return (FsWriterMetrics)new ObjectMapper().readValue(in, FsWriterMetrics.class);
    }

    public void setWriterId(String writerId) {
        this.writerId = writerId;
    }

    public void setPartitionInfo(PartitionIdentifier partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public void setFileInfos(Collection<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsWriterMetrics)) {
            return false;
        }
        FsWriterMetrics other = (FsWriterMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$writerId = this.getWriterId();
        String other$writerId = other.getWriterId();
        if (this$writerId == null ? other$writerId != null : !this$writerId.equals(other$writerId)) {
            return false;
        }
        PartitionIdentifier this$partitionInfo = this.getPartitionInfo();
        PartitionIdentifier other$partitionInfo = other.getPartitionInfo();
        if (this$partitionInfo == null ? other$partitionInfo != null : !((Object)this$partitionInfo).equals(other$partitionInfo)) {
            return false;
        }
        Collection<FileInfo> this$fileInfos = this.getFileInfos();
        Collection<FileInfo> other$fileInfos = other.getFileInfos();
        return !(this$fileInfos == null ? other$fileInfos != null : !((Object)this$fileInfos).equals(other$fileInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FsWriterMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $writerId = this.getWriterId();
        result = result * 59 + ($writerId == null ? 43 : $writerId.hashCode());
        PartitionIdentifier $partitionInfo = this.getPartitionInfo();
        result = result * 59 + ($partitionInfo == null ? 43 : ((Object)$partitionInfo).hashCode());
        Collection<FileInfo> $fileInfos = this.getFileInfos();
        result = result * 59 + ($fileInfos == null ? 43 : ((Object)$fileInfos).hashCode());
        return result;
    }

    public String toString() {
        return "FsWriterMetrics(writerId=" + this.getWriterId() + ", partitionInfo=" + this.getPartitionInfo() + ", fileInfos=" + this.getFileInfos() + ")";
    }

    public FsWriterMetrics() {
    }

    @ConstructorProperties(value={"writerId", "partitionInfo", "fileInfos"})
    public FsWriterMetrics(String writerId, PartitionIdentifier partitionInfo, Collection<FileInfo> fileInfos) {
        this.writerId = writerId;
        this.partitionInfo = partitionInfo;
        this.fileInfos = fileInfos;
    }

    public String getWriterId() {
        return this.writerId;
    }

    public PartitionIdentifier getPartitionInfo() {
        return this.partitionInfo;
    }

    public Collection<FileInfo> getFileInfos() {
        return this.fileInfos;
    }

    public static class FileInfo {
        String fileName;
        long numRecords;

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setNumRecords(long numRecords) {
            this.numRecords = numRecords;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            return this.getNumRecords() == other.getNumRecords();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            long $numRecords = this.getNumRecords();
            result = result * 59 + (int)($numRecords >>> 32 ^ $numRecords);
            return result;
        }

        public String toString() {
            return "FsWriterMetrics.FileInfo(fileName=" + this.getFileName() + ", numRecords=" + this.getNumRecords() + ")";
        }

        public FileInfo() {
        }

        @ConstructorProperties(value={"fileName", "numRecords"})
        public FileInfo(String fileName, long numRecords) {
            this.fileName = fileName;
            this.numRecords = numRecords;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getNumRecords() {
            return this.numRecords;
        }
    }
}

