/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.broker;

import com.google.common.base.Joiner;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.util.ConfigUtils;

public class KeyedScopedConfigViewImpl<S extends ScopeType<S>, K extends SharedResourceKey>
implements ScopedConfigView<S, K> {
    private static final Joiner JOINER = Joiner.on((String)".");
    @Nullable
    private final S scope;
    private final K key;
    private final String factoryName;
    private final Config fullConfig;

    public Config getFactorySpecificConfig() {
        return this.fullConfig;
    }

    public Config getScopedConfig() {
        if (this.scope == null) {
            return ConfigFactory.empty();
        }
        return ConfigUtils.getConfigOrEmpty(this.fullConfig, this.scope.name());
    }

    public Config getKeyedConfig() {
        if (this.key == null) {
            return ConfigFactory.empty();
        }
        String key = this.key.toConfigurationKey();
        if (key == null) {
            return ConfigFactory.empty();
        }
        return ConfigUtils.getConfigOrEmpty(this.fullConfig, this.key.toConfigurationKey());
    }

    public Config getKeyedScopedConfig() {
        if (this.scope == null || this.key.toConfigurationKey() == null) {
            return ConfigFactory.empty();
        }
        return ConfigUtils.getConfigOrEmpty(this.fullConfig, KeyedScopedConfigViewImpl.chainConfigKeys(this.scope.name(), this.key.toConfigurationKey()));
    }

    public Config getConfig() {
        return this.getKeyedScopedConfig().withFallback((ConfigMergeable)this.getKeyedConfig()).withFallback((ConfigMergeable)this.getScopedConfig()).withFallback((ConfigMergeable)this.getFactorySpecificConfig());
    }

    public ScopedConfigView<S, K> getScopedView(S scopeType) {
        return new KeyedScopedConfigViewImpl<S, K>(scopeType, this.key, this.factoryName, this.fullConfig);
    }

    private static String chainConfigKeys(String ... keys) {
        return JOINER.join((Object[])keys);
    }

    @ConstructorProperties(value={"scope", "key", "factoryName", "fullConfig"})
    public KeyedScopedConfigViewImpl(@Nullable S scope, K key, String factoryName, Config fullConfig) {
        this.scope = scope;
        this.key = key;
        this.factoryName = factoryName;
        this.fullConfig = fullConfig;
    }

    @Nullable
    public S getScope() {
        return this.scope;
    }

    public K getKey() {
        return this.key;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public Config getFullConfig() {
        return this.fullConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyedScopedConfigViewImpl)) {
            return false;
        }
        KeyedScopedConfigViewImpl other = (KeyedScopedConfigViewImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        S this$scope = this.getScope();
        S other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$factoryName = this.getFactoryName();
        String other$factoryName = other.getFactoryName();
        if (this$factoryName == null ? other$factoryName != null : !this$factoryName.equals(other$factoryName)) {
            return false;
        }
        Config this$fullConfig = this.getFullConfig();
        Config other$fullConfig = other.getFullConfig();
        return !(this$fullConfig == null ? other$fullConfig != null : !this$fullConfig.equals(other$fullConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyedScopedConfigViewImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        S $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $factoryName = this.getFactoryName();
        result = result * 59 + ($factoryName == null ? 43 : $factoryName.hashCode());
        Config $fullConfig = this.getFullConfig();
        result = result * 59 + ($fullConfig == null ? 43 : $fullConfig.hashCode());
        return result;
    }

    public String toString() {
        return "KeyedScopedConfigViewImpl(scope=" + this.getScope() + ", key=" + this.getKey() + ", factoryName=" + this.getFactoryName() + ", fullConfig=" + this.getFullConfig() + ")";
    }
}

