/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullFileLoader {
    private static final Logger log = LoggerFactory.getLogger(PullFileLoader.class);
    public static final String GLOBAL_PROPS_EXTENSION = ".properties";
    public static final PathFilter GLOBAL_PROPS_PATH_FILTER = new ExtensionFilter(".properties");
    public static final String GLOBAL_HOCON_EXTENSION = ".configuration";
    public static final PathFilter GLOBAL_HOCON_PATH_FILTER = new ExtensionFilter(".configuration");
    public static final PathFilter GLOBAL_PATH_FILTER = new ExtensionFilter(Lists.newArrayList((Object[])new String[]{".properties", ".configuration"}));
    public static final Set<String> DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"pull", "job"});
    public static final Set<String> DEFAULT_HOCON_PULL_FILE_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"json", "conf"});
    public static final String PROPERTY_DELIMITER_PARSING_ENABLED_KEY = "property.parsing.enablekey";
    public static final boolean DEFAULT_PROPERTY_DELIMITER_PARSING_ENABLED_KEY = false;
    private final Path rootDirectory;
    private final FileSystem fs;
    private final ExtensionFilter javaPropsPullFileFilter;
    private final ExtensionFilter hoconPullFileFilter;

    public PullFileLoader(Path rootDirectory, FileSystem fs, Collection<String> javaPropsPullFileExtensions, Collection<String> hoconPullFileExtensions) {
        Sets.SetView commonExtensions = Sets.intersection((Set)Sets.newHashSet(javaPropsPullFileExtensions), (Set)Sets.newHashSet(hoconPullFileExtensions));
        Preconditions.checkArgument((boolean)commonExtensions.isEmpty(), (Object)("Java props and HOCON pull file extensions intersect: " + Arrays.toString(commonExtensions.toArray())));
        this.rootDirectory = rootDirectory;
        this.fs = fs;
        this.javaPropsPullFileFilter = new ExtensionFilter(javaPropsPullFileExtensions);
        this.hoconPullFileFilter = new ExtensionFilter(hoconPullFileExtensions);
    }

    public Config loadPullFile(Path path, Config sysProps, boolean loadGlobalProperties) throws IOException {
        Config fallback;
        Config config = fallback = loadGlobalProperties ? this.loadAncestorGlobalConfigs(path, sysProps) : sysProps;
        if (this.javaPropsPullFileFilter.accept(path)) {
            return this.loadJavaPropsWithFallback(path, fallback).resolve();
        }
        if (this.hoconPullFileFilter.accept(path)) {
            return this.loadHoconConfigAtPath(path).withFallback((ConfigMergeable)fallback).resolve();
        }
        throw new IOException(String.format("Cannot load pull file %s due to unrecognized extension.", path));
    }

    public List<Config> loadPullFilesRecursively(Path path, Config sysProps, boolean loadGlobalProperties) {
        try {
            Config fallback = sysProps;
            if (loadGlobalProperties && PathUtils.isAncestor(this.rootDirectory, path.getParent())) {
                fallback = this.loadAncestorGlobalConfigs(path.getParent(), fallback);
            }
            return this.getSortedConfigs(this.loadPullFilesRecursivelyHelper(path, fallback, loadGlobalProperties));
        }
        catch (IOException ioe) {
            return Lists.newArrayList();
        }
    }

    private List<Config> getSortedConfigs(List<ConfigWithTimeStamp> configsWithTimeStamps) {
        ArrayList sortedConfigs = Lists.newArrayList();
        Collections.sort(configsWithTimeStamps, Comparator.comparingLong(o -> o.timeStamp));
        for (ConfigWithTimeStamp configWithTimeStamp : configsWithTimeStamps) {
            sortedConfigs.add(configWithTimeStamp.config);
        }
        return sortedConfigs;
    }

    private List<ConfigWithTimeStamp> loadPullFilesRecursivelyHelper(Path path, Config fallback, boolean loadGlobalProperties) {
        ArrayList pullFiles = Lists.newArrayList();
        try {
            FileStatus[] statuses;
            if (loadGlobalProperties) {
                fallback = this.findAndLoadGlobalConfigInDirectory(path, fallback);
            }
            if ((statuses = this.fs.listStatus(path)) == null) {
                log.error("Path does not exist: " + path);
                return pullFiles;
            }
            for (FileStatus status : statuses) {
                try {
                    if (status.isDirectory()) {
                        pullFiles.addAll(this.loadPullFilesRecursivelyHelper(status.getPath(), fallback, loadGlobalProperties));
                        continue;
                    }
                    if (this.javaPropsPullFileFilter.accept(status.getPath())) {
                        log.debug("modification time of {} is {}", (Object)status.getPath(), (Object)status.getModificationTime());
                        pullFiles.add(new ConfigWithTimeStamp(status.getModificationTime(), this.loadJavaPropsWithFallback(status.getPath(), fallback).resolve()));
                        continue;
                    }
                    if (!this.hoconPullFileFilter.accept(status.getPath())) continue;
                    log.debug("modification time of {} is {}", (Object)status.getPath(), (Object)status.getModificationTime());
                    pullFiles.add(new ConfigWithTimeStamp(status.getModificationTime(), this.loadHoconConfigAtPath(status.getPath()).withFallback((ConfigMergeable)fallback).resolve()));
                }
                catch (IOException ioe) {
                    log.error(String.format("Failed to load %s. Skipping.", status.getPath()));
                }
            }
            return pullFiles;
        }
        catch (IOException ioe) {
            log.error("Could not load properties at path: " + path, (Throwable)ioe);
            return Lists.newArrayList();
        }
    }

    private Config loadAncestorGlobalConfigs(Path path, Config sysProps) throws IOException {
        Config config = sysProps;
        if (!PathUtils.isAncestor(this.rootDirectory, path)) {
            log.warn(String.format("Loaded path %s is not a descendant of root path %s. Cannot load global properties.", path, this.rootDirectory));
        } else {
            ArrayList ancestorPaths = Lists.newArrayList();
            while (PathUtils.isAncestor(this.rootDirectory, path)) {
                ancestorPaths.add(path);
                path = path.getParent();
            }
            List reversedAncestors = Lists.reverse((List)ancestorPaths);
            for (Path ancestor : reversedAncestors) {
                config = this.findAndLoadGlobalConfigInDirectory(ancestor, config);
            }
        }
        return config;
    }

    private Config findAndLoadGlobalConfigInDirectory(Path path, Config fallback) throws IOException {
        FileStatus[] files = this.fs.listStatus(path, GLOBAL_PATH_FILTER);
        if (files == null) {
            log.warn("Could not list files at path " + path);
            return ConfigFactory.empty();
        }
        if (files.length > 1) {
            throw new IOException("Found more than one global properties file at path " + path);
        }
        if (files.length == 0) {
            return fallback;
        }
        if (GLOBAL_HOCON_PATH_FILTER.accept(files[0].getPath())) {
            return this.loadHoconConfigWithFallback(files[0].getPath(), fallback);
        }
        if (GLOBAL_PROPS_PATH_FILTER.accept(files[0].getPath())) {
            return this.loadJavaPropsWithFallback(files[0].getPath(), fallback);
        }
        throw new IllegalStateException("Unsupported global configuration file: " + files[0].getPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Config loadJavaPropsWithFallback(Path propertiesPath, Config fallback) throws IOException {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.fs.open(propertiesPath), Charsets.UTF_8);){
            propertiesConfiguration.setDelimiterParsingDisabled(ConfigUtils.getBoolean(fallback, PROPERTY_DELIMITER_PARSING_ENABLED_KEY, false));
            propertiesConfiguration.load((Reader)inputStreamReader);
            Config configFromProps = ConfigUtils.propertiesToConfig(ConfigurationConverter.getProperties((Configuration)propertiesConfiguration));
            Config config = ConfigFactory.parseMap((Map)ImmutableMap.of((Object)"job.config.path", (Object)PathUtils.getPathWithoutSchemeAndAuthority(propertiesPath).toString())).withFallback((ConfigMergeable)configFromProps).withFallback((ConfigMergeable)fallback);
            return config;
        }
        catch (ConfigurationException ce) {
            throw new IOException(ce);
        }
    }

    /*
     * Exception decompiling
     */
    private Config loadHoconConfigAtPath(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Config loadHoconConfigWithFallback(Path path, Config fallback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public ExtensionFilter getJavaPropsPullFileFilter() {
        return this.javaPropsPullFileFilter;
    }

    public ExtensionFilter getHoconPullFileFilter() {
        return this.hoconPullFileFilter;
    }

    private static class ConfigWithTimeStamp {
        long timeStamp;
        Config config;

        public ConfigWithTimeStamp(long timeStamp, Config config) {
            this.timeStamp = timeStamp;
            this.config = config;
        }
    }

    private static class ExtensionFilter
    implements PathFilter {
        private final Collection<String> extensions = Lists.newArrayList();

        public ExtensionFilter(String extension) {
            this(Lists.newArrayList((Object[])new String[]{extension}));
        }

        public ExtensionFilter(Collection<String> extensions) {
            for (String ext : extensions) {
                this.extensions.add(ext.startsWith(".") ? ext : "." + ext);
            }
        }

        public boolean accept(final Path path) {
            Predicate<String> predicate = new Predicate<String>(){

                public boolean apply(String input) {
                    return path.getName().toLowerCase().endsWith(input);
                }
            };
            return Iterables.any(this.extensions, (Predicate)predicate);
        }
    }
}

