/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.concurrent.CancellableTask;
import org.apache.gobblin.util.concurrent.ScheduledTask;
import org.apache.gobblin.util.concurrent.TaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduledExecutorServiceTaskScheduler<K, T extends ScheduledTask<K>>
extends TaskScheduler<K, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledExecutorServiceTaskScheduler.class);
    private ScheduledExecutorService executorService;

    ScheduledExecutorServiceTaskScheduler() {
    }

    @Override
    final void startImpl(Optional<String> name) {
        this.executorService = ExecutorsUtils.loggingDecorator(Executors.newScheduledThreadPool(0, ExecutorsUtils.newDaemonThreadFactory((Optional<Logger>)Optional.of((Object)LOGGER), name)));
    }

    @Override
    final CancellableTask<K, T> scheduleImpl(T task, long period, TimeUnit unit) {
        ScheduledFuture<?> future = this.executorService.scheduleAtFixedRate(new RunnableTask(this, task), 0L, period, unit);
        return new CancellableScheduledFuture(this, task, future);
    }

    @Override
    final void closeImpl() throws IOException {
        ExecutorsUtils.shutdownExecutorService(this.executorService, (Optional<Logger>)Optional.of((Object)LOGGER));
    }

    private static class CancellableScheduledFuture<K2, T2 extends ScheduledTask<K2>>
    extends CancellableTask<K2, T2> {
        private final ScheduledFuture<?> future;
        final /* synthetic */ ScheduledExecutorServiceTaskScheduler this$0;

        public CancellableScheduledFuture(T2 task, ScheduledFuture<?> future) {
            this.this$0 = var1_1;
            super(task);
            this.future = future;
        }

        @Override
        public boolean cancel() {
            this.future.cancel(true);
            return true;
        }
    }

    private static class RunnableTask
    implements Runnable {
        private final T task;
        final /* synthetic */ ScheduledExecutorServiceTaskScheduler this$0;

        public RunnableTask(T task) {
            this.this$0 = var1_1;
            this.task = task;
        }

        @Override
        public void run() {
            this.task.runOneIteration();
        }
    }
}

