/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.deprecation;

import java.util.List;
import org.apache.gobblin.configuration.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecationUtils {
    private static final Logger log = LoggerFactory.getLogger(DeprecationUtils.class);

    public static void renameDeprecatedKeys(State state, String currentKey, List<String> deprecatedKeys) {
        if (state.contains(currentKey)) {
            return;
        }
        for (String oldKey : deprecatedKeys) {
            if (!state.contains(oldKey)) continue;
            log.info("Copying the value of deprecated key " + oldKey + " into key " + currentKey);
            state.setProp(currentKey, (Object)state.getProp(oldKey));
            return;
        }
    }
}

