/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public class MDCPropagatingCallable<T>
implements Callable<T> {
    private final Callable<T> callable;
    private final Map<String, String> context;

    public MDCPropagatingCallable(Callable<T> callable) {
        this.callable = callable;
        this.context = MDC.getCopyOfContextMap();
    }

    @Override
    public T call() throws Exception {
        T answer;
        Map originalContext = MDC.getCopyOfContextMap();
        if (this.context != null) {
            MDC.setContextMap(this.context);
        }
        try {
            answer = this.callable.call();
        }
        finally {
            if (originalContext != null) {
                MDC.setContextMap((Map)originalContext);
            } else {
                MDC.clear();
            }
        }
        return answer;
    }
}

