/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import java.util.Map;
import org.slf4j.MDC;

public class MDCPropagatingRunnable
implements Runnable {
    private final Runnable runnable;
    private final Map<String, String> context;

    public MDCPropagatingRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.context = MDC.getCopyOfContextMap();
    }

    @Override
    public void run() {
        Map originalContext = MDC.getCopyOfContextMap();
        if (this.context != null) {
            MDC.setContextMap(this.context);
        }
        try {
            this.runnable.run();
        }
        finally {
            if (originalContext != null) {
                MDC.setContextMap((Map)originalContext);
            } else {
                MDC.clear();
            }
        }
    }
}

