/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.executors;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.executors.MDCPropagatingCallable;
import org.apache.gobblin.util.executors.MDCPropagatingRunnable;

public class MDCPropagatingScheduledExecutorService
extends ForwardingListeningExecutorService
implements ListeningScheduledExecutorService {
    private final ListeningScheduledExecutorService executorService;

    public MDCPropagatingScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService instanceof ListeningScheduledExecutorService ? (ListeningScheduledExecutorService)executorService : MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
    }

    protected ListeningExecutorService delegate() {
        return this.executorService;
    }

    public void execute(Runnable command) {
        super.execute((Runnable)new MDCPropagatingRunnable(command));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return super.submit(new MDCPropagatingCallable<T>(task));
    }

    public ListenableFuture<?> submit(Runnable task) {
        return super.submit((Runnable)new MDCPropagatingRunnable(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        return super.submit((Runnable)new MDCPropagatingRunnable(task), result);
    }

    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)new MDCPropagatingRunnable(command), null);
        ListenableScheduledFuture scheduled = this.executorService.schedule((Runnable)task, delay, unit);
        return new ListenableScheduledTask(task, (ScheduledFuture<?>)scheduled);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ListenableFutureTask task = ListenableFutureTask.create(new MDCPropagatingCallable<V>(callable));
        ListenableScheduledFuture scheduled = this.executorService.schedule((Runnable)task, delay, unit);
        return new ListenableScheduledTask(task, (ScheduledFuture<?>)scheduled);
    }

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(new MDCPropagatingRunnable(command));
        ListenableScheduledFuture scheduled = this.executorService.scheduleAtFixedRate((Runnable)task, initialDelay, period, unit);
        return new ListenableScheduledTask(task, (ScheduledFuture<?>)scheduled);
    }

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(new MDCPropagatingRunnable(command));
        ListenableScheduledFuture scheduled = this.executorService.scheduleWithFixedDelay((Runnable)task, initialDelay, delay, unit);
        return new ListenableScheduledTask(task, (ScheduledFuture<?>)scheduled);
    }

    private static final class NeverSuccessfulListenableFutureTask
    extends AbstractFuture<Void>
    implements Runnable {
        private final Runnable delegate;

        public NeverSuccessfulListenableFutureTask(Runnable delegate) {
            this.delegate = (Runnable)Preconditions.checkNotNull((Object)delegate);
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Throwable t) {
                this.setException(t);
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    private static final class ListenableScheduledTask<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
    implements ListenableScheduledFuture<V> {
        private final ScheduledFuture<?> scheduledDelegate;

        public ListenableScheduledTask(ListenableFuture<V> listenableDelegate, ScheduledFuture<?> scheduledDelegate) {
            super(listenableDelegate);
            this.scheduledDelegate = scheduledDelegate;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled) {
                this.scheduledDelegate.cancel(mayInterruptIfRunning);
            }
            return cancelled;
        }

        public long getDelay(TimeUnit unit) {
            return this.scheduledDelegate.getDelay(unit);
        }

        public int compareTo(Delayed other) {
            return this.scheduledDelegate.compareTo(other);
        }
    }
}

