/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.codahale.metrics.Meter;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.gobblin.util.Decorator;

@NotThreadSafe
public class BatchedMeterDecorator
implements Decorator {
    private final Meter underlying;
    private final int updateFrequency;
    private int count;

    public BatchedMeterDecorator(Meter underlying, int updateFrequency) {
        this.underlying = underlying;
        this.updateFrequency = updateFrequency;
        this.count = 0;
    }

    public void mark() {
        ++this.count;
        if (this.count > this.updateFrequency) {
            this.updateUnderlying();
        }
    }

    public void mark(long n) {
        this.count = (int)((long)this.count + n);
        if (this.count > this.updateFrequency) {
            this.updateUnderlying();
        }
    }

    private void updateUnderlying() {
        this.underlying.mark((long)this.count);
        this.count = 0;
    }

    public Object getDecoratedObject() {
        return this.underlying;
    }

    public Meter getUnderlyingMeter() {
        return this.underlying;
    }
}

