/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.util.io.SeekableFSInputStream;
import org.apache.gobblin.util.io.StreamCopier;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class StreamUtils {
    public static FSDataInputStream convertStream(InputStream in) throws IOException {
        return new FSDataInputStream((InputStream)((Object)new SeekableFSInputStream(in)));
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return new StreamCopier(is, os).copy();
    }

    public static long copy(ReadableByteChannel inputChannel, WritableByteChannel outputChannel) throws IOException {
        return new StreamCopier(inputChannel, outputChannel).copy();
    }

    public static void tar(FileSystem fs, Path sourcePath, Path destPath) throws IOException {
        StreamUtils.tar(fs, fs, sourcePath, destPath);
    }

    public static void tar(FileSystem sourceFs, FileSystem destFs, Path sourcePath, Path destPath) throws IOException {
        block37: {
            try (FSDataOutputStream fsDataOutputStream = destFs.create(destPath);
                 TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)fsDataOutputStream), ConfigurationKeys.DEFAULT_CHARSET_ENCODING.name());){
                FileStatus fileStatus = sourceFs.getFileStatus(sourcePath);
                if (sourceFs.isDirectory(sourcePath)) {
                    StreamUtils.dirToTarArchiveOutputStreamRecursive(fileStatus, sourceFs, (Optional<Path>)Optional.absent(), tarArchiveOutputStream);
                    break block37;
                }
                try (FSDataInputStream fsDataInputStream = sourceFs.open(sourcePath);){
                    StreamUtils.fileToTarArchiveOutputStream(fileStatus, fsDataInputStream, new Path(sourcePath.getName()), tarArchiveOutputStream);
                }
            }
        }
    }

    private static void dirToTarArchiveOutputStreamRecursive(FileStatus dirFileStatus, FileSystem fs, Optional<Path> destDir, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        Preconditions.checkState((boolean)fs.isDirectory(dirFileStatus.getPath()));
        Path dir = destDir.isPresent() ? new Path((Path)destDir.get(), dirFileStatus.getPath().getName()) : new Path(dirFileStatus.getPath().getName());
        StreamUtils.dirToTarArchiveOutputStream(dir, tarArchiveOutputStream);
        for (FileStatus childFileStatus : fs.listStatus(dirFileStatus.getPath())) {
            Path childFile = new Path(dir, childFileStatus.getPath().getName());
            if (fs.isDirectory(childFileStatus.getPath())) {
                StreamUtils.dirToTarArchiveOutputStreamRecursive(childFileStatus, fs, (Optional<Path>)Optional.of((Object)childFile), tarArchiveOutputStream);
                continue;
            }
            try (FSDataInputStream fsDataInputStream = fs.open(childFileStatus.getPath());){
                StreamUtils.fileToTarArchiveOutputStream(childFileStatus, fsDataInputStream, childFile, tarArchiveOutputStream);
            }
        }
    }

    private static void dirToTarArchiveOutputStream(Path destDir, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(StreamUtils.formatPathToDir(destDir));
        tarArchiveEntry.setModTime(System.currentTimeMillis());
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        tarArchiveOutputStream.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fileToTarArchiveOutputStream(FileStatus fileStatus, FSDataInputStream fsDataInputStream, Path destFile, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(StreamUtils.formatPathToFile(destFile));
        tarArchiveEntry.setSize(fileStatus.getLen());
        tarArchiveEntry.setModTime(System.currentTimeMillis());
        tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        try {
            IOUtils.copy((InputStream)fsDataInputStream, (OutputStream)tarArchiveOutputStream);
        }
        finally {
            tarArchiveOutputStream.closeArchiveEntry();
        }
    }

    private static String formatPathToDir(Path path) {
        return path.toString().endsWith("/") ? path.toString() : path.toString() + "/";
    }

    private static String formatPathToFile(Path path) {
        return StringUtils.removeEnd((String)path.toString(), (String)"/");
    }

    public static boolean isCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }

    public static void byteBufferToOutputStream(ByteBuffer in, OutputStream out) throws IOException {
        int BUF_SIZE = 8192;
        if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + in.position(), in.remaining());
        } else {
            byte[] b = new byte[Math.min(in.remaining(), 8192)];
            while (in.remaining() > 0) {
                int bytesToRead = Math.min(in.remaining(), 8192);
                in.get(b, 0, bytesToRead);
                out.write(b, 0, bytesToRead);
            }
        }
    }
}

