/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.test;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;

public class StdoutWriter<D>
implements DataWriter<D> {
    private long _numRecordsWritten = 0L;
    private long _numBytesWritten = 0L;

    public void close() {
    }

    public void write(D record) throws IOException {
        if (null != record) {
            String s = record.toString();
            System.out.println(s);
            ++this._numRecordsWritten;
            this._numBytesWritten += (long)s.getBytes(Charset.defaultCharset()).length;
        }
    }

    public void commit() {
    }

    public void cleanup() {
    }

    public long recordsWritten() {
        return this._numRecordsWritten;
    }

    public long bytesWritten() throws IOException {
        return this._numBytesWritten;
    }

    public void flush() throws IOException {
        System.out.flush();
    }

    public static class Builder<D>
    extends DataWriterBuilder<Object, D> {
        public DataWriter<D> build() throws IOException {
            return new StdoutWriter();
        }
    }
}

