/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.gobblin.service.ExecutionStatus;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.JobId;
import org.apache.gobblin.service.JobState;
import org.apache.gobblin.service.JobStatistics;

public class JobStatus
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobStatus\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Execution status for a job\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"record\",\"name\":\"FlowId\",\"doc\":\"Identifier for a Gobblin as a Service flow\",\"fields\":[{\"name\":\"flowName\",\"type\":\"string\",\"doc\":\"Name of the flow\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"flowGroup\",\"type\":\"string\",\"doc\":\"Group of the flow. This defines the namespace for the flow.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the flow the job belongs to\"},{\"name\":\"jobId\",\"type\":{\"type\":\"record\",\"name\":\"JobId\",\"doc\":\"Identifier for a Gobblin job\",\"fields\":[{\"name\":\"jobName\",\"type\":\"string\",\"doc\":\"Name of the job\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"jobGroup\",\"type\":\"string\",\"doc\":\"Group of the job. This defines the namespace for the job.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the job\"},{\"name\":\"executionStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExecutionStatus\",\"doc\":\"Execution status for a flow or job\",\"symbols\":[\"RUNNING\",\"FAILED\",\"COMPLETE\"],\"symbolDocs\":{\"RUNNING\":\"Flow or job is currently executing\",\"FAILED\":\"Flow or job failed\",\"COMPLETE\":\"Flow or job completed execution\"}},\"doc\":\"Job execution status\"},{\"name\":\"message\",\"type\":\"string\",\"doc\":\"Error or status message\"},{\"name\":\"executionStatistics\",\"type\":{\"type\":\"record\",\"name\":\"JobStatistics\",\"doc\":\"Statistics from a job execution\",\"fields\":[{\"name\":\"executionStartTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution began\"},{\"name\":\"executionEndTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution ended\"},{\"name\":\"processedCount\",\"type\":\"long\",\"doc\":\"number of records processed in the last job execution\"}]},\"doc\":\"Statistics from the job execution. The values may be updated during the run of a job.\"},{\"name\":\"jobState\",\"type\":{\"type\":\"record\",\"name\":\"JobState\",\"doc\":\"Job state that is updated at the end of an execution\",\"fields\":[{\"name\":\"lowWatermark\",\"type\":\"string\",\"doc\":\"Low watermark after last execution\"},{\"name\":\"highWatermark\",\"type\":\"string\",\"doc\":\"High watermark after last execution\"}]},\"doc\":\"Job state that is updated only at the start and end of a job execution.\"}]}");
    private static final RecordDataSchema.Field FIELD_FlowId = SCHEMA.getField("flowId");
    private static final RecordDataSchema.Field FIELD_JobId = SCHEMA.getField("jobId");
    private static final RecordDataSchema.Field FIELD_ExecutionStatus = SCHEMA.getField("executionStatus");
    private static final RecordDataSchema.Field FIELD_Message = SCHEMA.getField("message");
    private static final RecordDataSchema.Field FIELD_ExecutionStatistics = SCHEMA.getField("executionStatistics");
    private static final RecordDataSchema.Field FIELD_JobState = SCHEMA.getField("jobState");

    public JobStatus() {
        super(new DataMap(), SCHEMA);
    }

    public JobStatus(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasFlowId() {
        return this.contains(FIELD_FlowId);
    }

    public void removeFlowId() {
        this.remove(FIELD_FlowId);
    }

    public FlowId getFlowId(GetMode mode) {
        return (FlowId)this.obtainWrapped(FIELD_FlowId, FlowId.class, mode);
    }

    @Nonnull
    public FlowId getFlowId() {
        return (FlowId)this.obtainWrapped(FIELD_FlowId, FlowId.class, GetMode.STRICT);
    }

    public JobStatus setFlowId(FlowId value, SetMode mode) {
        this.putWrapped(FIELD_FlowId, FlowId.class, (DataTemplate)value, mode);
        return this;
    }

    public JobStatus setFlowId(@Nonnull FlowId value) {
        this.putWrapped(FIELD_FlowId, FlowId.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobId() {
        return this.contains(FIELD_JobId);
    }

    public void removeJobId() {
        this.remove(FIELD_JobId);
    }

    public JobId getJobId(GetMode mode) {
        return (JobId)this.obtainWrapped(FIELD_JobId, JobId.class, mode);
    }

    @Nonnull
    public JobId getJobId() {
        return (JobId)this.obtainWrapped(FIELD_JobId, JobId.class, GetMode.STRICT);
    }

    public JobStatus setJobId(JobId value, SetMode mode) {
        this.putWrapped(FIELD_JobId, JobId.class, (DataTemplate)value, mode);
        return this;
    }

    public JobStatus setJobId(@Nonnull JobId value) {
        this.putWrapped(FIELD_JobId, JobId.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasExecutionStatus() {
        return this.contains(FIELD_ExecutionStatus);
    }

    public void removeExecutionStatus() {
        this.remove(FIELD_ExecutionStatus);
    }

    public ExecutionStatus getExecutionStatus(GetMode mode) {
        return (ExecutionStatus)((Object)this.obtainDirect(FIELD_ExecutionStatus, ExecutionStatus.class, mode));
    }

    @Nonnull
    public ExecutionStatus getExecutionStatus() {
        return (ExecutionStatus)((Object)this.obtainDirect(FIELD_ExecutionStatus, ExecutionStatus.class, GetMode.STRICT));
    }

    public JobStatus setExecutionStatus(ExecutionStatus value, SetMode mode) {
        this.putDirect(FIELD_ExecutionStatus, ExecutionStatus.class, String.class, (Object)value, mode);
        return this;
    }

    public JobStatus setExecutionStatus(@Nonnull ExecutionStatus value) {
        this.putDirect(FIELD_ExecutionStatus, ExecutionStatus.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMessage() {
        return this.contains(FIELD_Message);
    }

    public void removeMessage() {
        this.remove(FIELD_Message);
    }

    public String getMessage(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Message, String.class, mode);
    }

    @Nonnull
    public String getMessage() {
        return (String)this.obtainDirect(FIELD_Message, String.class, GetMode.STRICT);
    }

    public JobStatus setMessage(String value, SetMode mode) {
        this.putDirect(FIELD_Message, String.class, String.class, value, mode);
        return this;
    }

    public JobStatus setMessage(@Nonnull String value) {
        this.putDirect(FIELD_Message, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasExecutionStatistics() {
        return this.contains(FIELD_ExecutionStatistics);
    }

    public void removeExecutionStatistics() {
        this.remove(FIELD_ExecutionStatistics);
    }

    public JobStatistics getExecutionStatistics(GetMode mode) {
        return (JobStatistics)this.obtainWrapped(FIELD_ExecutionStatistics, JobStatistics.class, mode);
    }

    @Nonnull
    public JobStatistics getExecutionStatistics() {
        return (JobStatistics)this.obtainWrapped(FIELD_ExecutionStatistics, JobStatistics.class, GetMode.STRICT);
    }

    public JobStatus setExecutionStatistics(JobStatistics value, SetMode mode) {
        this.putWrapped(FIELD_ExecutionStatistics, JobStatistics.class, (DataTemplate)value, mode);
        return this;
    }

    public JobStatus setExecutionStatistics(@Nonnull JobStatistics value) {
        this.putWrapped(FIELD_ExecutionStatistics, JobStatistics.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobState() {
        return this.contains(FIELD_JobState);
    }

    public void removeJobState() {
        this.remove(FIELD_JobState);
    }

    public JobState getJobState(GetMode mode) {
        return (JobState)this.obtainWrapped(FIELD_JobState, JobState.class, mode);
    }

    @Nonnull
    public JobState getJobState() {
        return (JobState)this.obtainWrapped(FIELD_JobState, JobState.class, GetMode.STRICT);
    }

    public JobStatus setJobState(JobState value, SetMode mode) {
        this.putWrapped(FIELD_JobState, JobState.class, (DataTemplate)value, mode);
        return this;
    }

    public JobStatus setJobState(@Nonnull JobState value) {
        this.putWrapped(FIELD_JobState, JobState.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobStatus clone() throws CloneNotSupportedException {
        return (JobStatus)super.clone();
    }

    public JobStatus copy() throws CloneNotSupportedException {
        return (JobStatus)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FlowId.Fields flowId() {
            return new FlowId.Fields(this.getPathComponents(), "flowId");
        }

        public JobId.Fields jobId() {
            return new JobId.Fields(this.getPathComponents(), "jobId");
        }

        public PathSpec executionStatus() {
            return new PathSpec(this.getPathComponents(), "executionStatus");
        }

        public PathSpec message() {
            return new PathSpec(this.getPathComponents(), "message");
        }

        public JobStatistics.Fields executionStatistics() {
            return new JobStatistics.Fields(this.getPathComponents(), "executionStatistics");
        }

        public JobState.Fields jobState() {
            return new JobState.Fields(this.getPathComponents(), "jobState");
        }
    }
}

