/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.service.JobStatus;

public class JobStatusArray
extends WrappingArrayTemplate<JobStatus> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"JobStatus\",\"namespace\":\"org.apache.gobblin.service\",\"doc\":\"Execution status for a job\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"record\",\"name\":\"FlowId\",\"doc\":\"Identifier for a Gobblin as a Service flow\",\"fields\":[{\"name\":\"flowName\",\"type\":\"string\",\"doc\":\"Name of the flow\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"flowGroup\",\"type\":\"string\",\"doc\":\"Group of the flow. This defines the namespace for the flow.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the flow the job belongs to\"},{\"name\":\"jobId\",\"type\":{\"type\":\"record\",\"name\":\"JobId\",\"doc\":\"Identifier for a Gobblin job\",\"fields\":[{\"name\":\"jobName\",\"type\":\"string\",\"doc\":\"Name of the job\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}},{\"name\":\"jobGroup\",\"type\":\"string\",\"doc\":\"Group of the job. This defines the namespace for the job.\",\"validate\":{\"strlen\":{\"min\":1,\"max\":128}}}]},\"doc\":\"Identifier of the job\"},{\"name\":\"executionStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExecutionStatus\",\"doc\":\"Execution status for a flow or job\",\"symbols\":[\"RUNNING\",\"FAILED\",\"COMPLETE\"],\"symbolDocs\":{\"RUNNING\":\"Flow or job is currently executing\",\"FAILED\":\"Flow or job failed\",\"COMPLETE\":\"Flow or job completed execution\"}},\"doc\":\"Job execution status\"},{\"name\":\"message\",\"type\":\"string\",\"doc\":\"Error or status message\"},{\"name\":\"executionStatistics\",\"type\":{\"type\":\"record\",\"name\":\"JobStatistics\",\"doc\":\"Statistics from a job execution\",\"fields\":[{\"name\":\"executionStartTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution began\"},{\"name\":\"executionEndTime\",\"type\":\"long\",\"doc\":\"Epoch time of when the execution ended\"},{\"name\":\"processedCount\",\"type\":\"long\",\"doc\":\"number of records processed in the last job execution\"}]},\"doc\":\"Statistics from the job execution. The values may be updated during the run of a job.\"},{\"name\":\"jobState\",\"type\":{\"type\":\"record\",\"name\":\"JobState\",\"doc\":\"Job state that is updated at the end of an execution\",\"fields\":[{\"name\":\"lowWatermark\",\"type\":\"string\",\"doc\":\"Low watermark after last execution\"},{\"name\":\"highWatermark\",\"type\":\"string\",\"doc\":\"High watermark after last execution\"}]},\"doc\":\"Job state that is updated only at the start and end of a job execution.\"}]}}");

    public JobStatusArray() {
        this(new DataList());
    }

    public JobStatusArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public JobStatusArray(Collection<JobStatus> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public JobStatusArray(DataList data) {
        super(data, SCHEMA, JobStatus.class);
    }

    public JobStatusArray clone() throws CloneNotSupportedException {
        return (JobStatusArray)super.clone();
    }

    public JobStatusArray copy() throws CloneNotSupportedException {
        return (JobStatusArray)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public JobStatus.Fields items() {
            return new JobStatus.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

