/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.r2.transport.common.Client;
import com.linkedin.r2.transport.common.bridge.client.TransportClientAdapter;
import com.linkedin.r2.transport.http.client.HttpClientFactory;
import com.linkedin.restli.client.FindRequest;
import com.linkedin.restli.client.GetRequest;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestClient;
import com.linkedin.restli.common.CollectionResponse;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.EmptyRecord;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.service.FlowId;
import org.apache.gobblin.service.FlowStatus;
import org.apache.gobblin.service.FlowStatusId;
import org.apache.gobblin.service.FlowstatusesGetRequestBuilder;
import org.apache.gobblin.service.FlowstatusesRequestBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStatusClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStatusClient.class);
    private Optional<HttpClientFactory> _httpClientFactory;
    private Optional<RestClient> _restClient;
    private final FlowstatusesRequestBuilders _flowstatusesRequestBuilders;

    public FlowStatusClient(String serverUri) {
        LOG.debug("FlowConfigClient with serverUri " + serverUri);
        this._httpClientFactory = Optional.of((Object)new HttpClientFactory());
        TransportClientAdapter r2Client = new TransportClientAdapter(((HttpClientFactory)this._httpClientFactory.get()).getClient(Collections.emptyMap()));
        this._restClient = Optional.of((Object)new RestClient((Client)r2Client, serverUri));
        this._flowstatusesRequestBuilders = new FlowstatusesRequestBuilders();
    }

    public FlowStatusClient(RestClient restClient) {
        LOG.debug("FlowConfigClient with restClient " + restClient);
        this._httpClientFactory = Optional.absent();
        this._restClient = Optional.of((Object)restClient);
        this._flowstatusesRequestBuilders = new FlowstatusesRequestBuilders();
    }

    public FlowStatus getFlowStatus(FlowStatusId flowStatusId) throws RemoteInvocationException {
        LOG.debug("getFlowConfig with groupName " + flowStatusId.getFlowGroup() + " flowName " + flowStatusId.getFlowName());
        GetRequest getRequest = ((FlowstatusesGetRequestBuilder)this._flowstatusesRequestBuilders.get().id((Object)new ComplexResourceKey((RecordTemplate)flowStatusId, (RecordTemplate)new EmptyRecord()))).build();
        Response response = ((RestClient)this._restClient.get()).sendRequest((Request)getRequest).getResponse();
        return (FlowStatus)response.getEntity();
    }

    public FlowStatus getLatestFlowStatus(FlowId flowId) throws RemoteInvocationException {
        LOG.debug("getFlowConfig with groupName " + flowId.getFlowGroup() + " flowName " + flowId.getFlowName());
        FindRequest findRequest = this._flowstatusesRequestBuilders.findByLatestFlowStatus().flowIdParam(flowId).build();
        Response response = ((RestClient)this._restClient.get()).sendRequest((Request)findRequest).getResponse();
        List flowStatusList = ((CollectionResponse)response.getEntity()).getElements();
        if (flowStatusList.isEmpty()) {
            return null;
        }
        Preconditions.checkArgument((flowStatusList.size() == 1 ? 1 : 0) != 0);
        return (FlowStatus)flowStatusList.get(0);
    }

    @Override
    public void close() throws IOException {
        if (this._restClient.isPresent()) {
            ((RestClient)this._restClient.get()).shutdown((Callback)new FutureCallback());
        }
        if (this._httpClientFactory.isPresent()) {
            ((HttpClientFactory)this._httpClientFactory.get()).shutdown((Callback)new FutureCallback());
        }
    }
}

