/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.upgrade;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.data.StatPersistedV1;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.server.upgrade.DataNodeV1;
import org.apache.zookeeper.server.upgrade.DataTreeV1;
import org.apache.zookeeper.server.upgrade.UpgradeSnapShot;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeSnapShotV1
implements UpgradeSnapShot {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeSnapShotV1.class);
    ConcurrentHashMap<Long, Integer> sessionsWithTimeouts = new ConcurrentHashMap();
    File dataDir;
    File snapShotDir;
    DataTreeV1 oldDataTree;

    public UpgradeSnapShotV1(File dataDir, File snapShotDir) {
        this.dataDir = dataDir;
        this.snapShotDir = snapShotDir;
        this.oldDataTree = new DataTreeV1();
    }

    private void deserializeSnapshot(DataTreeV1 oldTree, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count = ia.readInt("count"); count > 0; --count) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        oldTree.deserialize(ia, "tree");
    }

    public long playLog(InputArchive logStream) throws IOException {
        long highestZxid = 0L;
        try {
            while (true) {
                byte[] bytes;
                if ((bytes = logStream.readBuffer("txnEntry")).length == 0) {
                    throw new EOFException();
                }
                TxnHeader hdr = new TxnHeader();
                Record txn = SerializeUtils.deserializeTxn(bytes, hdr);
                if (logStream.readByte("EOR") != 66) {
                    LOG.warn("Last transaction was partial.");
                    throw new EOFException("Last transaction was partial.");
                }
                if (hdr.getZxid() <= highestZxid && highestZxid != 0L) {
                    LOG.error(highestZxid + "(higestZxid) >= " + hdr.getZxid() + "(next log) for type " + hdr.getType());
                } else {
                    highestZxid = hdr.getZxid();
                }
                switch (hdr.getType()) {
                    case -10: {
                        this.sessionsWithTimeouts.put(hdr.getClientId(), ((CreateSessionTxn)txn).getTimeOut());
                        if (LOG.isTraceEnabled()) {
                            ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: 0x" + Long.toHexString(hdr.getClientId()) + " with timeout: " + ((CreateSessionTxn)txn).getTimeOut());
                        }
                        this.oldDataTree.processTxn(hdr, txn);
                        break;
                    }
                    case -11: {
                        this.sessionsWithTimeouts.remove(hdr.getClientId());
                        if (LOG.isTraceEnabled()) {
                            ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: 0x" + Long.toHexString(hdr.getClientId()));
                        }
                        this.oldDataTree.processTxn(hdr, txn);
                        break;
                    }
                    default: {
                        this.oldDataTree.processTxn(hdr, txn);
                    }
                }
                Request r = new Request(null, 0L, hdr.getCxid(), hdr.getType(), null, null);
                r.txn = txn;
                r.hdr = hdr;
                r.zxid = hdr.getZxid();
            }
        }
        catch (EOFException e) {
            return highestZxid;
        }
    }

    private long processLogFiles(DataTreeV1 oldTree, File[] logFiles) throws IOException {
        long zxid = 0L;
        for (File f : logFiles) {
            LOG.info("Processing log file: " + f);
            BufferedInputStream logIs = new BufferedInputStream(new FileInputStream(f));
            zxid = this.playLog(BinaryInputArchive.getArchive(logIs));
            ((InputStream)logIs).close();
        }
        return zxid;
    }

    private void loadThisSnapShot() throws IOException {
        File snapshot = this.findMostRecentSnapshot();
        if (snapshot == null) {
            throw new IOException("Invalid snapshots or not snapshots in " + this.snapShotDir);
        }
        BufferedInputStream inputstream = new BufferedInputStream(new FileInputStream(snapshot));
        BinaryInputArchive ia = BinaryInputArchive.getArchive(inputstream);
        this.deserializeSnapshot(this.oldDataTree, ia, this.sessionsWithTimeouts);
        long snapshotZxid = this.oldDataTree.lastProcessedZxid;
        File[] files = FileTxnLog.getLogFiles(this.dataDir.listFiles(), snapshotZxid);
        long zxid = this.processLogFiles(this.oldDataTree, files);
        if (zxid != this.oldDataTree.lastProcessedZxid) {
            LOG.error("Zxids not equal  log zxid " + zxid + " datatree processed " + this.oldDataTree.lastProcessedZxid);
        }
    }

    private File findMostRecentSnapshot() throws IOException {
        List<File> files = Util.sortDataDir(this.snapShotDir.listFiles(), "snapshot", false);
        for (File f : files) {
            try {
                if (!Util.isValidSnapshot(f)) continue;
                return f;
            }
            catch (IOException e) {
                LOG.info("Invalid snapshot " + f, (Throwable)e);
            }
        }
        return null;
    }

    private StatPersisted convertStat(StatPersistedV1 oldStat) {
        StatPersisted stat = new StatPersisted();
        stat.setAversion(oldStat.getAversion());
        stat.setCtime(oldStat.getCtime());
        stat.setCversion(oldStat.getCversion());
        stat.setCzxid(oldStat.getCzxid());
        stat.setEphemeralOwner(oldStat.getEphemeralOwner());
        stat.setMtime(oldStat.getMtime());
        stat.setMzxid(oldStat.getMzxid());
        stat.setVersion(oldStat.getVersion());
        return stat;
    }

    private DataNode convertDataNode(DataTree dt, DataNode parent, DataNodeV1 oldDataNode) {
        StatPersisted stat = this.convertStat(oldDataNode.stat);
        DataNode dataNode = new DataNode(parent, oldDataNode.data, dt.getACL(oldDataNode), stat);
        dataNode.setChildren(oldDataNode.children);
        return dataNode;
    }

    private void recurseThroughDataTree(DataTree dataTree, String path) {
        if (path == null) {
            return;
        }
        DataNodeV1 oldDataNode = this.oldDataTree.getNode(path);
        HashSet<String> children = oldDataNode.children;
        DataNode parent = null;
        if ("".equals(path)) {
            parent = null;
        } else {
            int lastSlash = path.lastIndexOf(47);
            String parentPath = path.substring(0, lastSlash);
            parent = dataTree.getNode(parentPath);
        }
        DataNode thisDatNode = this.convertDataNode(dataTree, parent, oldDataNode);
        dataTree.addDataNode(path, thisDatNode);
        if (children == null || children.size() == 0) {
            return;
        }
        for (String child : children) {
            this.recurseThroughDataTree(dataTree, path + "/" + child);
        }
    }

    private DataTree convertThisSnapShot() throws IOException {
        DataTree dataTree = new DataTree();
        DataNodeV1 oldDataNode = this.oldDataTree.getNode("");
        if (oldDataNode == null) {
            LOG.error("Upgrading from an empty snapshot.");
        }
        this.recurseThroughDataTree(dataTree, "");
        dataTree.lastProcessedZxid = this.oldDataTree.lastProcessedZxid;
        return dataTree;
    }

    @Override
    public DataTree getNewDataTree() throws IOException {
        this.loadThisSnapShot();
        DataTree dt = this.convertThisSnapShot();
        return dt;
    }

    @Override
    public ConcurrentHashMap<Long, Integer> getSessionWithTimeOuts() {
        return this.sessionsWithTimeouts;
    }
}

