/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.snapshot.check;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.restli.tools.compatibility.CompatibilityInfoMap;
import com.linkedin.restli.tools.compatibility.CompatibilityReport;
import com.linkedin.restli.tools.compatibility.CompatibilityUtil;
import com.linkedin.restli.tools.compatibility.ResourceCompatibilityChecker;
import com.linkedin.restli.tools.idlcheck.CompatibilityInfo;
import com.linkedin.restli.tools.idlcheck.CompatibilityLevel;
import com.linkedin.restli.tools.snapshot.check.AbstractSnapshot;
import com.linkedin.restli.tools.snapshot.check.RestSpec;
import com.linkedin.restli.tools.snapshot.check.Snapshot;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class RestLiSnapshotCompatibilityChecker {
    private String _resolverPath;
    private final CompatibilityInfoMap _infoMap = new CompatibilityInfoMap();

    public static void main(String[] args) {
        CompatibilityLevel compat;
        CommandLine cmd;
        Options options = new Options();
        options.addOption("h", "help", false, "Print help");
        OptionBuilder.withArgName((String)"compatibility_level");
        OptionBuilder.withLongOpt((String)"compat");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)("Compatibility level " + RestLiSnapshotCompatibilityChecker.listCompatLevelOptions()));
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"report");
        OptionBuilder.withDescription((String)"Prints a report at the end of the execution that can be parsed for reporting to other tools");
        options.addOption(OptionBuilder.create((String)"report"));
        String cmdLineSyntax = RestLiSnapshotCompatibilityChecker.class.getCanonicalName() + " [pairs of <prevRestspecPath currRestspecPath>]";
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
            return;
        }
        String[] targets = cmd.getArgs();
        if (cmd.hasOption('h') || targets.length < 2 || targets.length % 2 != 0) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
        }
        String compatValue = cmd.hasOption('c') ? cmd.getOptionValue('c') : CompatibilityLevel.DEFAULT.name();
        try {
            compat = CompatibilityLevel.valueOf(compatValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            new HelpFormatter().printHelp(cmdLineSyntax, options, true);
            System.exit(255);
            return;
        }
        String resolverPath = System.getProperty("generator.resolver.path");
        RestLiSnapshotCompatibilityChecker checker = new RestLiSnapshotCompatibilityChecker();
        checker.setResolverPath(resolverPath);
        for (int i = 1; i < targets.length; i += 2) {
            String prevTarget = targets[i - 1];
            String currTarget = targets[i];
            checker.checkCompatibility(prevTarget, currTarget, compat, prevTarget.endsWith(".restspec.json"));
        }
        String summary = checker.getInfoMap().createSummary();
        if (compat != CompatibilityLevel.OFF && summary.length() > 0) {
            System.out.println(summary);
        }
        if (cmd.hasOption("report")) {
            System.out.println(new CompatibilityReport(checker.getInfoMap(), compat).createReport());
            System.exit(0);
        }
        System.exit(checker.getInfoMap().isCompatible(compat) ? 0 : 1);
    }

    public void setResolverPath(String resolverPath) {
        this._resolverPath = resolverPath;
    }

    public CompatibilityInfoMap check(String prevSnapshotPath, String currSnapshotPath, CompatibilityLevel compatLevel) {
        return this.checkCompatibility(prevSnapshotPath, currSnapshotPath, compatLevel, false);
    }

    public CompatibilityInfoMap checkRestSpecVsSnapshot(String prevRestSpecPath, String currSnapshotPath, CompatibilityLevel compatLevel) {
        return this.checkCompatibility(prevRestSpecPath, currSnapshotPath, compatLevel, true);
    }

    private CompatibilityInfoMap checkCompatibility(String prevRestModelPath, String currRestModelPath, CompatibilityLevel compatLevel, boolean isAgainstRestSpec) {
        CompatibilityInfoMap infoMap = this._infoMap;
        if (compatLevel == CompatibilityLevel.OFF) {
            return infoMap;
        }
        Stack<Object> path = new Stack<Object>();
        path.push("");
        FileInputStream prevSnapshotFile = null;
        FileInputStream currSnapshotFile = null;
        try {
            prevSnapshotFile = new FileInputStream(prevRestModelPath);
        }
        catch (FileNotFoundException e) {
            infoMap.addRestSpecInfo(CompatibilityInfo.Type.RESOURCE_NEW, path, currRestModelPath);
        }
        try {
            currSnapshotFile = new FileInputStream(currRestModelPath);
        }
        catch (FileNotFoundException e) {
            infoMap.addRestSpecInfo(CompatibilityInfo.Type.RESOURCE_MISSING, path, prevRestModelPath);
        }
        if (prevSnapshotFile == null || currSnapshotFile == null) {
            return infoMap;
        }
        AbstractSnapshot prevSnapshot = null;
        Snapshot currSnapshot = null;
        try {
            prevSnapshot = isAgainstRestSpec ? new RestSpec(prevSnapshotFile) : new Snapshot(prevSnapshotFile);
            currSnapshot = new Snapshot(currSnapshotFile);
        }
        catch (IOException e) {
            infoMap.addRestSpecInfo(CompatibilityInfo.Type.OTHER_ERROR, path, e.getMessage());
        }
        if (prevSnapshot == null || currSnapshot == null) {
            return infoMap;
        }
        DataSchemaResolver currResolver = RestLiSnapshotCompatibilityChecker.createResolverFromSnapshot(currSnapshot, this._resolverPath);
        DataSchemaResolver prevResolver = isAgainstRestSpec ? currResolver : RestLiSnapshotCompatibilityChecker.createResolverFromSnapshot(prevSnapshot, this._resolverPath);
        ResourceCompatibilityChecker checker = new ResourceCompatibilityChecker(prevSnapshot.getResourceSchema(), prevResolver, currSnapshot.getResourceSchema(), currResolver);
        checker.check(compatLevel);
        infoMap.addAll(checker.getInfoMap());
        return infoMap;
    }

    private static String listCompatLevelOptions() {
        StringBuilder options = new StringBuilder("<");
        for (CompatibilityLevel compatLevel : CompatibilityLevel.values()) {
            options.append(compatLevel.name().toLowerCase()).append("|");
        }
        options.replace(options.length() - 1, options.length(), ">");
        return options.toString();
    }

    private static DataSchemaResolver createResolverFromSnapshot(AbstractSnapshot snapshot, String resolverPath) {
        DataSchemaResolver resolver = CompatibilityUtil.getDataSchemaResolver(resolverPath);
        for (Map.Entry<String, NamedDataSchema> entry : snapshot.getModels().entrySet()) {
            Name name = new Name(entry.getKey());
            NamedDataSchema schema = entry.getValue();
            resolver.bindNameToSchema(name, schema, DataSchemaLocation.NO_LOCATION);
        }
        return resolver;
    }

    public CompatibilityInfoMap getInfoMap() {
        return this._infoMap;
    }
}

