/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Host;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeHostsResult
implements Serializable,
Cloneable {
    private SdkInternalList<Host> hosts;
    private String nextToken;

    public List<Host> getHosts() {
        if (this.hosts == null) {
            this.hosts = new SdkInternalList();
        }
        return this.hosts;
    }

    public void setHosts(Collection<Host> hosts) {
        if (hosts == null) {
            this.hosts = null;
            return;
        }
        this.hosts = new SdkInternalList(hosts);
    }

    public DescribeHostsResult withHosts(Host ... hosts) {
        if (this.hosts == null) {
            this.setHosts((Collection<Host>)new SdkInternalList(hosts.length));
        }
        for (Host ele : hosts) {
            this.hosts.add((Object)ele);
        }
        return this;
    }

    public DescribeHostsResult withHosts(Collection<Host> hosts) {
        this.setHosts(hosts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeHostsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHosts() != null) {
            sb.append("Hosts: " + this.getHosts() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsResult)) {
            return false;
        }
        DescribeHostsResult other = (DescribeHostsResult)obj;
        if (other.getHosts() == null ^ this.getHosts() == null) {
            return false;
        }
        if (other.getHosts() != null && !other.getHosts().equals(this.getHosts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHosts() == null ? 0 : this.getHosts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeHostsResult clone() {
        try {
            return (DescribeHostsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

