/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyHostsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyHostsRequestMarshaller
implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {
    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {
        if (modifyHostsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList hostIdsList = (SdkInternalList)modifyHostsRequest.getHostIds();
        if (!hostIdsList.isEmpty() || !hostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String hostIdsListValue : hostIdsList) {
                if (hostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)hostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (modifyHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString((String)modifyHostsRequest.getAutoPlacement()));
        }
        return request;
    }
}

