/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

import com.linkedin.common.callback.Callback;
import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Engine;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.server.RequestExecutionCallback;
import com.linkedin.restli.server.RequestExecutionReport;
import com.linkedin.restli.server.RequestExecutionReportBuilder;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.resources.BaseResource;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RestLiMethodInvoker {
    private final ResourceFactory _resourceFactory;
    private final Engine _engine;
    private final ErrorResponseBuilder _errorResponseBuilder;
    public static final ThreadLocal<Context> TASK_CONTEXT = new ThreadLocal();

    public RestLiMethodInvoker(ResourceFactory resourceFactory, Engine engine) {
        this(resourceFactory, engine, new ErrorResponseBuilder());
    }

    public RestLiMethodInvoker(ResourceFactory resourceFactory, Engine engine, ErrorResponseBuilder errorResponseBuilder) {
        this._resourceFactory = resourceFactory;
        this._engine = engine;
        this._errorResponseBuilder = errorResponseBuilder;
    }

    private void doInvoke(ResourceMethodDescriptor descriptor, final RequestExecutionCallback<Object> callback, RequestExecutionReportBuilder requestExecutionReportBuilder, Object resource, final ServerResourceContext resourceContext, Object ... arguments) throws IllegalAccessException {
        Method method = descriptor.getMethod();
        try {
            switch (descriptor.getInterfaceType()) {
                case CALLBACK: {
                    int callbackIndex = descriptor.indexOfParameterType(Parameter.ParamType.CALLBACK);
                    final RequestExecutionReport executionReport = RestLiMethodInvoker.getRequestExecutionReport(requestExecutionReportBuilder);
                    arguments[callbackIndex] = new Callback<Object>(){

                        public void onError(Throwable e) {
                            callback.onError(e instanceof RestLiServiceException ? e : new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, e), executionReport, resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments());
                        }

                        public void onSuccess(Object result) {
                            callback.onSuccess(result, executionReport, resourceContext.getResponseAttachments());
                        }
                    };
                    method.invoke(resource, arguments);
                    break;
                }
                case SYNC: {
                    Object applicationResult = method.invoke(resource, arguments);
                    callback.onSuccess(applicationResult, RestLiMethodInvoker.getRequestExecutionReport(requestExecutionReportBuilder), resourceContext.getResponseAttachments());
                    break;
                }
                case PROMISE: {
                    if (!this.checkEngine(resourceContext, callback, descriptor, requestExecutionReportBuilder)) break;
                    int contextIndex = descriptor.indexOfParameterType(Parameter.ParamType.PARSEQ_CONTEXT_PARAM);
                    if (contextIndex == -1) {
                        contextIndex = descriptor.indexOfParameterType(Parameter.ParamType.PARSEQ_CONTEXT);
                    }
                    RestLiParSeqTask restliTask = new RestLiParSeqTask(arguments, contextIndex, method, resource);
                    restliTask.addListener(new CallbackPromiseAdapter<Object>(callback, (Task<Object>)restliTask, requestExecutionReportBuilder, resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments()));
                    this.runTask((Task<Object>)restliTask, this.toPlanClass(descriptor));
                    break;
                }
                case TASK: {
                    if (!this.checkEngine(resourceContext, callback, descriptor, requestExecutionReportBuilder)) break;
                    Task task = (Task)method.invoke(resource, arguments);
                    if (task == null) {
                        callback.onError(new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Error in application code: null Task"), RestLiMethodInvoker.getRequestExecutionReport(requestExecutionReportBuilder), resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments());
                        break;
                    }
                    task.addListener(new CallbackPromiseAdapter<Object>(callback, task, requestExecutionReportBuilder, resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments()));
                    this.runTask((Task<Object>)task, this.toPlanClass(descriptor));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected interface type " + (Object)((Object)descriptor.getInterfaceType())));
                }
            }
        }
        catch (InvocationTargetException e) {
            if (RestLiServiceException.class.isAssignableFrom(e.getCause().getClass())) {
                RestLiServiceException restLiServiceException = (RestLiServiceException)e.getCause();
                callback.onError(restLiServiceException, RestLiMethodInvoker.getRequestExecutionReport(requestExecutionReportBuilder), resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments());
            }
            callback.onError(new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, this._errorResponseBuilder.getInternalErrorMessage(), e.getCause()), RestLiMethodInvoker.getRequestExecutionReport(requestExecutionReportBuilder), resourceContext.getRequestAttachmentReader(), resourceContext.getResponseAttachments());
        }
    }

    private String toPlanClass(ResourceMethodDescriptor descriptor) {
        StringBuilder sb = new StringBuilder();
        sb.append("resource=").append(descriptor.getResourceName());
        sb.append(",");
        sb.append("method=").append(descriptor.getType());
        if (descriptor.getFinderName() != null) {
            sb.append(",").append("finder=").append(descriptor.getFinderName());
        }
        if (descriptor.getActionName() != null) {
            sb.append(",").append("action=").append(descriptor.getActionName());
        }
        return sb.toString();
    }

    private void runTask(Task<Object> task, String planClass) {
        Context taskContext = TASK_CONTEXT.get();
        if (taskContext == null) {
            this._engine.run(task, planClass);
        } else {
            taskContext.run(new Task[]{task});
        }
    }

    private boolean checkEngine(ServerResourceContext resourceContext, RequestExecutionCallback<Object> callback, ResourceMethodDescriptor desc, RequestExecutionReportBuilder executionReportBuilder) {
        if (this._engine == null) {
            String fmt = "ParSeq based method %s.%s, but no engine given. Check your RestLiServer construction, spring wiring, and container-pegasus-restli-server-cmpt version.";
            String clazz = desc.getResourceModel().getResourceClass().getName();
            String method = desc.getMethod().getName();
            String msg = String.format("ParSeq based method %s.%s, but no engine given. Check your RestLiServer construction, spring wiring, and container-pegasus-restli-server-cmpt version.", clazz, method);
            callback.onError(new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, msg), RestLiMethodInvoker.getRequestExecutionReport(executionReportBuilder), resourceContext.getRequestAttachmentReader(), null);
            return false;
        }
        return true;
    }

    private static RequestExecutionReport getRequestExecutionReport(RequestExecutionReportBuilder requestExecutionReportBuilder) {
        return requestExecutionReportBuilder == null ? null : requestExecutionReportBuilder.build();
    }

    public void invoke(RestLiRequestData requestData, RoutingResult invocableMethod, RestLiArgumentBuilder restLiArgumentBuilder, RequestExecutionCallback<Object> callback, RequestExecutionReportBuilder requestExecutionReportBuilder) {
        try {
            ResourceMethodDescriptor resourceMethodDescriptor = invocableMethod.getResourceMethod();
            Object resource = this._resourceFactory.create(resourceMethodDescriptor.getResourceModel().getResourceClass());
            ServerResourceContext resourceContext = (ServerResourceContext)invocableMethod.getContext();
            if (BaseResource.class.isAssignableFrom(resource.getClass())) {
                ((BaseResource)resource).setContext(resourceContext);
            }
            Object[] args = restLiArgumentBuilder.buildArguments(requestData, invocableMethod);
            this.doInvoke(resourceMethodDescriptor, callback, requestExecutionReportBuilder, resource, resourceContext, args);
        }
        catch (Exception e) {
            callback.onError(e, requestExecutionReportBuilder == null ? null : requestExecutionReportBuilder.build(), ((ServerResourceContext)invocableMethod.getContext()).getRequestAttachmentReader(), invocableMethod.getContext().getResponseAttachments());
        }
    }

    private static class CallbackPromiseAdapter<T>
    implements PromiseListener<T> {
        private final RequestExecutionCallback<T> _callback;
        private final RequestExecutionReportBuilder _executionReportBuilder;
        private final RestLiAttachmentReader _requestAttachments;
        private final RestLiResponseAttachments _responseAttachments;
        private final Task<T> _associatedTask;

        public CallbackPromiseAdapter(RequestExecutionCallback<T> callback, Task<T> associatedTask, RequestExecutionReportBuilder executionReportBuilder, RestLiAttachmentReader requestAttachments, RestLiResponseAttachments responseAttachments) {
            this._callback = callback;
            this._associatedTask = associatedTask;
            this._executionReportBuilder = executionReportBuilder;
            this._requestAttachments = requestAttachments;
            this._responseAttachments = responseAttachments;
        }

        public void onResolved(Promise<T> promise) {
            if (this._executionReportBuilder != null) {
                this._executionReportBuilder.setParseqTrace(this._associatedTask.getTrace());
            }
            RequestExecutionReport executionReport = RestLiMethodInvoker.getRequestExecutionReport(this._executionReportBuilder);
            if (promise.isFailed()) {
                this._callback.onError(promise.getError() instanceof RestLiServiceException ? promise.getError() : new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, promise.getError()), executionReport, this._requestAttachments, this._responseAttachments);
            } else {
                this._callback.onSuccess(promise.get(), executionReport, this._responseAttachments);
            }
        }
    }

    private static class RestLiParSeqTask
    extends BaseTask<Object> {
        private final Object[] _arguments;
        private final int _contextIndex;
        private final Method _method;
        private final Object _resource;

        public RestLiParSeqTask(Object[] arguments, int contextIndex, Method method, Object resource) {
            this._arguments = arguments;
            this._contextIndex = contextIndex;
            this._method = method;
            this._resource = resource;
        }

        protected Promise<?> run(Context context) {
            try {
                Object applicationResult;
                if (this._contextIndex != -1) {
                    this._arguments[this._contextIndex] = context;
                }
                if ((applicationResult = this._method.invoke(this._resource, this._arguments)) == null) {
                    return Promises.error((Throwable)new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Error in application code: null Promise"));
                }
                return (Promise)applicationResult;
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException && t.getCause() != null) {
                    return Promises.error((Throwable)(t.getCause() instanceof RestLiServiceException ? t.getCause() : new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, t.getCause())));
                }
                return Promises.error((Throwable)(t instanceof RestLiServiceException ? t : new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, t)));
            }
        }
    }
}

