/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.filter;

import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RestLiCallback;
import com.linkedin.restli.internal.server.filter.FilterChainCallback;
import com.linkedin.restli.internal.server.filter.RestLiFilterResponseContextFactory;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.filter.FilterRequestContext;
import com.linkedin.restli.server.filter.FilterResponseContext;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class RestLiFilterChainIterator {
    private List<Filter> _filters;
    private FilterChainCallback _filterChainCallback;
    private int _cursor;

    public RestLiFilterChainIterator(List<Filter> filters, FilterChainCallback filterChainCallback) {
        this._filters = filters;
        this._filterChainCallback = filterChainCallback;
        this._cursor = 0;
    }

    public void onRequest(FilterRequestContext requestContext, RestLiFilterResponseContextFactory<Object> filterResponseContextFactory, RestLiCallback<Object> restLiCallback) {
        if (this._cursor < this._filters.size()) {
            CompletableFuture<Void> filterFuture;
            try {
                filterFuture = this._filters.get(this._cursor++).onRequest(requestContext);
            }
            catch (Throwable th) {
                this.onError(th, requestContext, filterResponseContextFactory.fromThrowable(th), null);
                return;
            }
            filterFuture.thenAccept(v -> this.onRequest(requestContext, filterResponseContextFactory, restLiCallback));
            filterFuture.exceptionally(throwable -> {
                this.onError((Throwable)throwable, requestContext, filterResponseContextFactory.fromThrowable((Throwable)throwable), null);
                return null;
            });
        } else {
            this._filterChainCallback.onRequestSuccess(requestContext.getRequestData(), restLiCallback);
        }
    }

    public void onResponse(FilterRequestContext requestContext, FilterResponseContext responseContext, RestLiResponseAttachments responseAttachments) {
        if (this._cursor > 0) {
            CompletableFuture<Void> filterFuture;
            try {
                filterFuture = this._filters.get(--this._cursor).onResponse(requestContext, responseContext);
            }
            catch (Throwable th) {
                this.updateResponseContextWithError(th, responseContext);
                this.onError(th, requestContext, responseContext, responseAttachments);
                return;
            }
            filterFuture.thenAccept(v -> this.onResponse(requestContext, responseContext, responseAttachments));
            filterFuture.exceptionally(throwable -> {
                this.updateResponseContextWithError((Throwable)throwable, responseContext);
                this.onError((Throwable)throwable, requestContext, responseContext, responseAttachments);
                return null;
            });
        } else {
            this._filterChainCallback.onResponseSuccess(responseContext.getResponseData(), responseAttachments);
        }
    }

    public void onError(Throwable th, FilterRequestContext requestContext, FilterResponseContext responseContext, RestLiResponseAttachments responseAttachments) {
        if (this._cursor > 0) {
            CompletableFuture<Void> filterFuture;
            try {
                filterFuture = this._filters.get(--this._cursor).onError(th, requestContext, responseContext);
            }
            catch (Throwable t) {
                this.updateResponseContextWithError(t, responseContext);
                this.onError(t, requestContext, responseContext, responseAttachments);
                return;
            }
            filterFuture.thenAccept(v -> this.onResponse(requestContext, responseContext, responseAttachments));
            filterFuture.exceptionally(throwable -> {
                this.updateResponseContextWithError((Throwable)throwable, responseContext);
                this.onError((Throwable)throwable, requestContext, responseContext, responseAttachments);
                return null;
            });
        } else {
            this._filterChainCallback.onError(th, responseContext.getResponseData(), responseAttachments);
        }
    }

    private void updateResponseContextWithError(Throwable throwable, FilterResponseContext responseContext) {
        Map<String, String> requestHeaders = responseContext.getResponseData().getHeaders();
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put("X-RestLi-Protocol-Version", ProtocolVersionUtil.extractProtocolVersion(requestHeaders).toString());
        headers.put(HeaderUtil.getErrorResponseHeaderName(requestHeaders), "true");
        RestLiResponseDataImpl responseData = (RestLiResponseDataImpl)responseContext.getResponseData();
        responseData.getHeaders().putAll(headers);
        responseData.setException(throwable);
    }
}

