/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.template.TyperefInfo;
import com.linkedin.restli.server.annotations.Key;
import com.linkedin.restli.server.annotations.RestAnnotations;
import com.linkedin.restli.server.annotations.RestLiAssociation;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.annotations.RestLiSimpleResource;

public class RestLiAnnotationData {
    private final Class<?> _parent;
    private final String _name;
    private final String _namespace;
    private final Key[] _keys;
    private final String _keyName;
    private final Class<? extends TyperefInfo> _typerefInfoClass;

    public RestLiAnnotationData(RestLiCollection collectionAnno) {
        this._parent = collectionAnno.parent();
        this._name = collectionAnno.name();
        this._namespace = collectionAnno.namespace();
        this._keys = null;
        this._keyName = "__DEFAULT__".equals(collectionAnno.keyName()) ? null : collectionAnno.keyName();
        this._typerefInfoClass = RestAnnotations.NULL_TYPEREF_INFO.class.equals(collectionAnno.keyTyperefClass()) ? null : collectionAnno.keyTyperefClass();
    }

    public RestLiAnnotationData(RestLiAssociation associationAnno) {
        this._parent = associationAnno.parent();
        this._name = associationAnno.name();
        this._namespace = associationAnno.namespace();
        this._keys = associationAnno.assocKeys();
        this._keyName = "__DEFAULT__".equals(associationAnno.keyName()) ? null : associationAnno.keyName();
        this._typerefInfoClass = null;
    }

    public RestLiAnnotationData(RestLiSimpleResource simpleResourceAnno) {
        this._parent = simpleResourceAnno.parent();
        this._name = simpleResourceAnno.name();
        this._namespace = simpleResourceAnno.namespace();
        this._keys = null;
        this._keyName = null;
        this._typerefInfoClass = null;
    }

    public Class<?> parent() {
        return this._parent;
    }

    public String name() {
        return this._name;
    }

    public String namespace() {
        return this._namespace;
    }

    public Key[] keys() {
        return this._keys;
    }

    public String keyName() {
        return this._keyName;
    }

    public Class<? extends TyperefInfo> typerefInfoClass() {
        return this._typerefInfoClass;
    }
}

