/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.IdResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.URIParamUtils;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.CreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.ResponseUtils;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.CreateKVResponse;
import com.linkedin.restli.server.CreateResponse;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CreateResponseBuilder
implements RestLiResponseBuilder {
    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        return new PartialRestResponse.Builder().entity(responseData.getRecordResponseEnvelope().getRecord()).headers(responseData.getHeaders()).cookies(responseData.getCookies()).status(responseData.getStatus()).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        CreateResponseEnvelope responseEnvelope;
        CreateResponse createResponse = (CreateResponse)result;
        if (createResponse.hasError()) {
            RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(createResponse.getError(), headers, cookies);
            responseData.setResponseEnvelope(new CreateResponseEnvelope(null, responseData));
            return responseData;
        }
        Object id = null;
        if (createResponse.hasId()) {
            id = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(createResponse.getId(), routingResult);
            ProtocolVersion protocolVersion = ((ServerResourceContext)routingResult.getContext()).getRestliProtocolVersion();
            String stringKey = URIParamUtils.encodeKeyForUri((Object)id, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT, (ProtocolVersion)protocolVersion);
            UriBuilder uribuilder = UriBuilder.fromUri((URI)request.getURI());
            uribuilder.path(stringKey);
            if (routingResult.getContext().hasParameter("altkey")) {
                uribuilder.queryParam("altkey", new Object[]{routingResult.getContext().getParameter("altkey")});
            }
            headers.put("Location", uribuilder.build(new Object[]{null}).toString());
            headers.put(HeaderUtil.getIdHeaderName((ProtocolVersion)protocolVersion), URIParamUtils.encodeKeyForHeader((Object)id, (ProtocolVersion)protocolVersion));
        }
        if (createResponse.getStatus() == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. HttpStatus is null inside of a CreateResponse from the resource method: " + routingResult.getResourceMethod());
        }
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(createResponse.getStatus(), headers, cookies);
        if (createResponse instanceof CreateKVResponse) {
            ResourceContext resourceContext = routingResult.getContext();
            DataMap entityData = ((CreateKVResponse)createResponse).getEntity().data();
            DataMap data = RestUtils.projectFields(entityData, resourceContext.getProjectionMode(), resourceContext.getProjectionMask());
            responseEnvelope = new CreateResponseEnvelope(new AnyRecord(data), true, responseData);
        } else {
            IdResponse idResponse = new IdResponse(id);
            responseEnvelope = new CreateResponseEnvelope((RecordTemplate)idResponse, responseData);
        }
        responseData.setResponseEnvelope(responseEnvelope);
        return responseData;
    }
}

