/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.IdResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.HeaderUtil;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PartialRestResponse {
    private final HttpStatus _status;
    private final RecordTemplate _record;
    private final Map<String, String> _headers;
    private final List<HttpCookie> _cookies;

    private PartialRestResponse(HttpStatus status, RecordTemplate record, Map<String, String> headers, List<HttpCookie> cookies) {
        this._record = record;
        this._status = status;
        ArrayList arrayList = this._cookies = cookies == null ? new ArrayList() : cookies;
        if (headers != null) {
            this._headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this._headers.putAll(headers);
        } else {
            this._headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public List<HttpCookie> getCookies() {
        return this._cookies;
    }

    public String getHeader(String headerName) {
        return this._headers.get(headerName);
    }

    public boolean hasData() {
        return this._record != null && this._record.data() != null;
    }

    public DataMap getDataMap() {
        return this._record == null ? null : this._record.data();
    }

    public HttpStatus getStatus() {
        return this._status;
    }

    public RecordTemplate getEntity() {
        return this._record;
    }

    public static class Builder {
        private HttpStatus _status = HttpStatus.S_200_OK;
        private RecordTemplate _record;
        private Map<String, String> _headers;
        private List<HttpCookie> _cookies;

        public Builder status(HttpStatus status) {
            this._status = status;
            return this;
        }

        public Builder entity(RecordTemplate record) {
            this._record = record;
            return this;
        }

        public Builder cookies(List<HttpCookie> cookies) {
            this._cookies = cookies;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this._headers = headers;
            return this;
        }

        public PartialRestResponse build() {
            IdResponse idResponse;
            Object key;
            if (this._record instanceof IdResponse && (key = (idResponse = (IdResponse)this._record).getId()) != null) {
                ProtocolVersion protocolVersion = ProtocolVersionUtil.extractProtocolVersion(this._headers);
                this._headers.put(HeaderUtil.getIdHeaderName((ProtocolVersion)protocolVersion), URIParamUtils.encodeKeyForHeader((Object)key, (ProtocolVersion)protocolVersion));
            }
            return new PartialRestResponse(this._status, this._record, this._headers, this._cookies);
        }
    }
}

