/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.util.AlternativeKeyCoercerException;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.server.RestLiServiceException;

public class ResponseUtils {
    static Object translateCanonicalKeyToAlternativeKeyIfNeeded(Object canonicalKey, RoutingResult routingResult) {
        if (routingResult.getContext().hasParameter("altkey")) {
            String altKeyName = routingResult.getContext().getParameter("altkey");
            ResourceModel resourceModel = routingResult.getResourceMethod().getResourceModel();
            try {
                return ArgumentUtils.translateToAlternativeKey(canonicalKey, altKeyName, resourceModel);
            }
            catch (AlternativeKeyCoercerException e) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, String.format("Unexpected Error when coercing canonical key '%s' to alternative key type '%s'", canonicalKey, altKeyName), e);
            }
        }
        return canonicalKey;
    }
}

