/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.util;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.codec.PsonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.restli.common.CollectionResponse;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.common.DataMapConverter;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.server.RoutingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.activation.MimeTypeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMapUtils {
    private static final JacksonDataCodec CODEC = new JacksonDataCodec();
    private static final PsonDataCodec PSON_DATA_CODEC = new PsonDataCodec();
    private static final JacksonDataTemplateCodec TEMPLATE_CODEC = new JacksonDataTemplateCodec();
    private static final Logger LOG = LoggerFactory.getLogger(DataMapUtils.class);

    public static DataMap readMap(InputStream stream) {
        try {
            return CODEC.readMap(stream);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static DataMap readMapPson(InputStream stream) {
        try {
            return PSON_DATA_CODEC.readMap(stream);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static DataMap readMap(RestMessage message) {
        try {
            return DataMapUtils.readMapWithExceptions(message);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    private static DataMap readMapWithExceptions(RestMessage message) throws IOException {
        try {
            return DataMapConverter.bytesToDataMap((String)message.getHeader("Content-Type"), (ByteString)message.getEntity());
        }
        catch (MimeTypeParseException e) {
            throw new RoutingException(e.getMessage(), HttpStatus.S_400_BAD_REQUEST.getCode(), e);
        }
    }

    public static <T extends RecordTemplate> T convert(DataMap data, Class<T> recordClass) {
        try {
            return (T)((RecordTemplate)recordClass.getConstructor(DataMap.class).newInstance(data));
        }
        catch (SecurityException e) {
            throw new RestLiInternalException(e);
        }
        catch (InstantiationException e) {
            throw new RestLiInternalException(e);
        }
        catch (IllegalAccessException e) {
            throw new RestLiInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new RestLiInternalException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static <T extends RecordTemplate> T read(InputStream stream, Class<T> recordClass) throws IOException {
        try {
            DataMap dataMap = CODEC.readMap(stream);
            return (T)((RecordTemplate)DataTemplateUtil.wrap((Object)dataMap, recordClass));
        }
        catch (IllegalArgumentException e) {
            throw new RestLiInternalException(e);
        }
        catch (SecurityException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static <T extends RecordTemplate> T read(RestMessage message, Class<T> recordClass) throws IOException {
        try {
            DataMap dataMap = DataMapUtils.readMapWithExceptions(message);
            return (T)((RecordTemplate)DataTemplateUtil.wrap((Object)dataMap, recordClass));
        }
        catch (IllegalArgumentException e) {
            throw new RestLiInternalException(e);
        }
        catch (SecurityException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static <T extends RecordTemplate> CollectionResponse<T> readCollectionResponse(InputStream stream, Class<T> recordClass) {
        try {
            DataMap dataMap = CODEC.readMap(stream);
            return new CollectionResponse(dataMap, recordClass);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static <T extends RecordTemplate> CollectionResponse<T> readCollectionResponse(RestMessage message, Class<T> recordClass) {
        DataMap dataMap = DataMapUtils.readMap(message);
        return new CollectionResponse(dataMap, recordClass);
    }

    public static void write(DataTemplate<?> record, OutputStream stream, boolean orderFields) {
        try {
            TEMPLATE_CODEC.writeDataTemplate(record, stream, orderFields);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static void write(Object data, DataSchema schema, OutputStream stream, boolean orderFields) {
        try {
            TEMPLATE_CODEC.writeDataTemplate(data, schema, stream, orderFields);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static byte[] dataTemplateToBytes(DataTemplate<?> record, boolean orderFields) {
        try {
            return TEMPLATE_CODEC.dataTemplateToBytes(record, orderFields);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static byte[] mapToBytes(DataMap dataMap) {
        try {
            return CODEC.mapToBytes(dataMap);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static ByteString mapToByteString(DataMap dataMap) {
        return ByteString.unsafeWrap((byte[])DataMapUtils.mapToBytes(dataMap));
    }

    public static byte[] listToBytes(DataList dataList) {
        try {
            return CODEC.listToBytes(dataList);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static byte[] dataComplexToBytes(DataComplex value) {
        if (value instanceof DataMap) {
            return DataMapUtils.mapToBytes((DataMap)value);
        }
        if (value instanceof DataList) {
            return DataMapUtils.listToBytes((DataList)value);
        }
        throw new IllegalStateException("Unknown DataComplex type: " + value.getClass());
    }

    public static byte[] mapToPsonBytes(DataMap dataMap) {
        try {
            return PSON_DATA_CODEC.mapToBytes(dataMap);
        }
        catch (IOException e) {
            throw new RestLiInternalException(e);
        }
    }

    public static ByteString mapToPsonByteString(DataMap dataMap) {
        return ByteString.unsafeWrap((byte[])DataMapUtils.mapToPsonBytes(dataMap));
    }
}

