/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.common.Version;
import com.linkedin.common.callback.Callback;
import com.linkedin.data.ByteString;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.multipart.MultiPartMIMEReader;
import com.linkedin.multipart.MultiPartMIMEReaderCallback;
import com.linkedin.multipart.MultiPartMIMEStreamResponseFactory;
import com.linkedin.multipart.MultiPartMIMEWriter;
import com.linkedin.multipart.SinglePartMIMEReaderCallback;
import com.linkedin.multipart.exceptions.MultiPartIllegalFormatException;
import com.linkedin.parseq.Engine;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.ByteStringWriter;
import com.linkedin.r2.util.URIUtil;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.common.attachments.RestLiAttachmentReaderException;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.AttachmentUtils;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RestLiMethodInvoker;
import com.linkedin.restli.internal.server.RestLiRouter;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.filter.FilterChainCallbackImpl;
import com.linkedin.restli.internal.server.filter.FilterRequestContextInternalImpl;
import com.linkedin.restli.internal.server.filter.RestLiFilterChain;
import com.linkedin.restli.internal.server.filter.RestLiFilterResponseContextFactory;
import com.linkedin.restli.internal.server.methods.MethodAdapterRegistry;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.model.RestLiApiBuilder;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseHandler;
import com.linkedin.restli.internal.server.util.MIMEParse;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.BaseRestServer;
import com.linkedin.restli.server.InvokeAware;
import com.linkedin.restli.server.RequestExecutionCallback;
import com.linkedin.restli.server.RequestExecutionReport;
import com.linkedin.restli.server.RequestExecutionReportBuilder;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiDebugRequestHandler;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.filter.Filter;
import com.linkedin.restli.server.multiplexer.MultiplexedRequestHandler;
import com.linkedin.restli.server.multiplexer.MultiplexedRequestHandlerImpl;
import com.linkedin.restli.server.resources.PrototypeResourceFactory;
import com.linkedin.restli.server.resources.ResourceFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiServer
extends BaseRestServer {
    public static final String DEBUG_PATH_SEGMENT = "__debug";
    private static final Logger log = LoggerFactory.getLogger(RestLiServer.class);
    private final RestLiConfig _config;
    private final RestLiRouter _router;
    private final ResourceFactory _resourceFactory;
    private final RestLiMethodInvoker _methodInvoker;
    private final RestLiResponseHandler _responseHandler;
    private final RestLiDocumentationRequestHandler _docRequestHandler;
    private final MultiplexedRequestHandler _multiplexedRequestHandler;
    private final ErrorResponseBuilder _errorResponseBuilder;
    private final Map<String, RestLiDebugRequestHandler> _debugHandlers;
    private final List<Filter> _filters;
    private final List<InvokeAware> _invokeAwares;
    private boolean _isDocInitialized = false;

    public RestLiServer(RestLiConfig config) {
        this(config, new PrototypeResourceFactory());
    }

    public RestLiServer(RestLiConfig config, ResourceFactory resourceFactory) {
        this(config, resourceFactory, null);
    }

    public RestLiServer(RestLiConfig config, ResourceFactory resourceFactory, Engine engine) {
        this(config, resourceFactory, engine, null);
    }

    @Deprecated
    public RestLiServer(RestLiConfig config, ResourceFactory resourceFactory, Engine engine, List<InvokeAware> invokeAwares) {
        super(config);
        this._config = config;
        this._errorResponseBuilder = new ErrorResponseBuilder(config.getErrorResponseFormat(), config.getInternalErrorMessage());
        this._resourceFactory = resourceFactory;
        this._rootResources = new RestLiApiBuilder(config).build();
        this._resourceFactory.setRootResources(this._rootResources);
        this._router = new RestLiRouter(this._rootResources);
        this._methodInvoker = new RestLiMethodInvoker(this._resourceFactory, engine, this._errorResponseBuilder);
        this._responseHandler = new RestLiResponseHandler.Builder().setErrorResponseBuilder(this._errorResponseBuilder).build();
        this._docRequestHandler = config.getDocumentationRequestHandler();
        this._debugHandlers = new HashMap<String, RestLiDebugRequestHandler>();
        this._filters = config.getFilters() != null ? config.getFilters() : new ArrayList<Filter>();
        for (RestLiDebugRequestHandler debugHandler : config.getDebugRequestHandlers()) {
            this._debugHandlers.put(debugHandler.getHandlerId(), debugHandler);
        }
        this._multiplexedRequestHandler = new MultiplexedRequestHandlerImpl(this, engine, config.getMaxRequestsMultiplexed(), config.getMultiplexedIndividualRequestHeaderWhitelist(), config.getMultiplexerSingletonFilter(), config.getMultiplexerRunMode());
        if (engine == null) {
            for (ResourceModel model : this._rootResources.values()) {
                for (ResourceMethodDescriptor desc : model.getResourceMethodDescriptors()) {
                    ResourceMethodDescriptor.InterfaceType type = desc.getInterfaceType();
                    if (type != ResourceMethodDescriptor.InterfaceType.PROMISE && type != ResourceMethodDescriptor.InterfaceType.TASK) continue;
                    String fmt = "ParSeq based method %s.%s, but no engine given. Check your RestLiServer construction, spring wiring, and container-pegasus-restli-server-cmpt version.";
                    log.warn(String.format("ParSeq based method %s.%s, but no engine given. Check your RestLiServer construction, spring wiring, and container-pegasus-restli-server-cmpt version.", model.getResourceClass().getName(), desc.getMethod().getName()));
                }
            }
        }
        this._invokeAwares = invokeAwares == null ? Collections.emptyList() : Collections.unmodifiableList(invokeAwares);
    }

    public Map<String, ResourceModel> getRootResources() {
        return Collections.unmodifiableMap(this._rootResources);
    }

    @Override
    protected void doHandleRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        if (this.verifyAttachmentSupportNotNeeded((Request)request, callback)) {
            return;
        }
        if (this.isDocumentationRequest((Request)request)) {
            this.handleDocumentationRequest(request, callback);
        } else if (this.isMultiplexedRequest((Request)request)) {
            this.handleMultiplexedRequest(request, requestContext, callback);
        } else {
            RestLiDebugRequestHandler debugHandlerForRequest = this.findDebugRequestHandler((Request)request);
            if (debugHandlerForRequest != null) {
                this.handleDebugRequest(debugHandlerForRequest, request, requestContext, null, new RestResponseExecutionCallbackAdapter(callback));
            } else {
                this.handleResourceRequest(request, requestContext, new RestResponseExecutionCallbackAdapter(callback), null, false);
            }
        }
    }

    private boolean isSupportedProtocolVersion(ProtocolVersion clientProtocolVersion, ProtocolVersion lowerBound, ProtocolVersion upperBound) {
        int lowerCheck = clientProtocolVersion.compareTo((Version)lowerBound);
        int upperCheck = clientProtocolVersion.compareTo((Version)upperBound);
        return lowerCheck >= 0 && upperCheck <= 0;
    }

    private void ensureRequestUsesValidRestliProtocol(RestRequest request) throws RestLiServiceException {
        ProtocolVersion upperBound;
        ProtocolVersion lowerBound;
        ProtocolVersion clientProtocolVersion = ProtocolVersionUtil.extractProtocolVersion((Map)request.getHeaders());
        if (!this.isSupportedProtocolVersion(clientProtocolVersion, lowerBound = AllProtocolVersions.OLDEST_SUPPORTED_PROTOCOL_VERSION, upperBound = AllProtocolVersions.NEXT_PROTOCOL_VERSION)) {
            throw new RestLiServiceException(HttpStatus.S_400_BAD_REQUEST, "Rest.li protocol version " + clientProtocolVersion + " used by the client is not supported!");
        }
    }

    private void handleDebugRequest(RestLiDebugRequestHandler debugHandler, RestRequest request, RequestContext requestContext, final RestLiAttachmentReader attachmentReader, RequestExecutionCallback<RestResponse> callback) {
        debugHandler.handleRequest(request, requestContext, new RestLiDebugRequestHandler.ResourceDebugRequestHandler(){

            @Override
            public void handleRequest(RestRequest request, RequestContext requestContext, RequestExecutionCallback<RestResponse> callback) {
                String fullPath = request.getURI().getPath();
                int debugSegmentIndex = fullPath.indexOf(RestLiServer.DEBUG_PATH_SEGMENT);
                RestRequestBuilder requestBuilder = new RestRequestBuilder(request);
                UriBuilder uriBuilder = UriBuilder.fromUri((URI)request.getURI());
                uriBuilder.replacePath(request.getURI().getPath().substring(0, debugSegmentIndex - 1));
                requestBuilder.setURI(uriBuilder.build(new Object[0]));
                RestLiServer.this.handleResourceRequest(requestBuilder.build(), requestContext, callback, attachmentReader, true);
            }
        }, attachmentReader, callback);
    }

    private void handleResourceRequest(RestRequest request, RequestContext requestContext, RequestExecutionCallback<RestResponse> callback, RestLiAttachmentReader attachmentReader, boolean isDebugMode) {
        RestLiArgumentBuilder adapter;
        RoutingResult method;
        try {
            this.ensureRequestUsesValidRestliProtocol(request);
        }
        catch (RestLiServiceException e) {
            this.respondWithPreRoutingError(e, request, attachmentReader, callback);
            return;
        }
        try {
            method = this._router.process(request, requestContext, attachmentReader);
        }
        catch (Exception e) {
            this.respondWithPreRoutingError(e, request, attachmentReader, callback);
            return;
        }
        RequestExecutionCallback<RestResponse> wrappedCallback = this.notifyInvokeAwares(method, callback);
        RequestExecutionReportBuilder requestExecutionReportBuilder = null;
        if (isDebugMode) {
            requestExecutionReportBuilder = new RequestExecutionReportBuilder();
        }
        FilterRequestContextInternalImpl filterContext = new FilterRequestContextInternalImpl((ServerResourceContext)method.getContext(), method.getResourceMethod());
        try {
            RestUtils.validateRequestHeadersAndUpdateResourceContext(request.getHeaders(), (ServerResourceContext)method.getContext());
            adapter = this.buildRestLiArgumentBuilder(method, this._errorResponseBuilder);
            filterContext.setRequestData(adapter.extractRequestData(method, request));
        }
        catch (Exception e) {
            wrappedCallback.onError(e, requestExecutionReportBuilder == null ? null : requestExecutionReportBuilder.build(), ((ServerResourceContext)method.getContext()).getRequestAttachmentReader(), null);
            return;
        }
        RestLiFilterResponseContextFactory filterResponseContextFactory = new RestLiFilterResponseContextFactory(request, method, this._responseHandler);
        FilterChainCallbackImpl filterChainCallback = new FilterChainCallbackImpl(method, this._methodInvoker, adapter, requestExecutionReportBuilder, attachmentReader, this._responseHandler, wrappedCallback);
        RestLiFilterChain filterChain = new RestLiFilterChain(this._filters, filterChainCallback);
        filterChain.onRequest(filterContext, filterResponseContextFactory);
    }

    private void respondWithPreRoutingError(Throwable th, RestRequest request, RestLiAttachmentReader attachmentReader, RequestExecutionCallback<RestResponse> callback) {
        RestLiFilterResponseContextFactory filterResponseContextFactory = new RestLiFilterResponseContextFactory(request, null, this._responseHandler);
        RestLiResponseData responseData = filterResponseContextFactory.fromThrowable(th).getResponseData();
        RestException restException = this._responseHandler.buildRestException(th, this._responseHandler.buildPartialResponse(null, responseData));
        callback.onError(restException, RestLiServer.createEmptyExecutionReport(), attachmentReader, null);
    }

    private RestLiArgumentBuilder buildRestLiArgumentBuilder(RoutingResult method, ErrorResponseBuilder errorResponseBuilder) {
        ResourceMethodDescriptor resourceMethodDescriptor = method.getResourceMethod();
        RestLiArgumentBuilder adapter = new MethodAdapterRegistry(errorResponseBuilder).getArgumentBuilder(resourceMethodDescriptor.getType());
        if (adapter == null) {
            throw new IllegalArgumentException("Unsupported method type: " + resourceMethodDescriptor.getType());
        }
        return adapter;
    }

    private RequestExecutionCallback<RestResponse> notifyInvokeAwares(RoutingResult routingResult, final RequestExecutionCallback<RestResponse> originalCallback) {
        if (!this._invokeAwares.isEmpty()) {
            final ArrayList<Callback<RestResponse>> invokeAwareCallbacks = new ArrayList<Callback<RestResponse>>();
            for (InvokeAware invokeAware : this._invokeAwares) {
                invokeAwareCallbacks.add(invokeAware.onInvoke(routingResult.getContext(), routingResult.getResourceMethod()));
            }
            return new RequestExecutionCallback<RestResponse>(){

                @Override
                public void onSuccess(RestResponse result, RequestExecutionReport executionReport, RestLiResponseAttachments responseAttachments) {
                    for (Callback callback : invokeAwareCallbacks) {
                        callback.onSuccess((Object)result);
                    }
                    originalCallback.onSuccess(result, executionReport, responseAttachments);
                }

                @Override
                public void onError(Throwable error, RequestExecutionReport executionReport, RestLiAttachmentReader requestAttachmentReader, RestLiResponseAttachments responseAttachments) {
                    for (Callback callback : invokeAwareCallbacks) {
                        callback.onError(error);
                    }
                    originalCallback.onError(error, executionReport, requestAttachmentReader, responseAttachments);
                }
            };
        }
        return originalCallback;
    }

    private boolean isMultiplexedRequest(Request request) {
        return this._multiplexedRequestHandler.isMultiplexedRequest(request);
    }

    private void handleMultiplexedRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        this._multiplexedRequestHandler.handleRequest(request, requestContext, callback);
    }

    private boolean isDocumentationRequest(Request request) {
        return this._docRequestHandler != null && this._docRequestHandler.isDocumentationRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentationRequest(RestRequest request, Callback<RestResponse> callback) {
        try {
            RestLiServer restLiServer = this;
            synchronized (restLiServer) {
                if (!this._isDocInitialized) {
                    this._docRequestHandler.initialize(this._config, this._rootResources);
                    this._isDocInitialized = true;
                }
            }
            RestResponse response = this._docRequestHandler.processDocumentationRequest((Request)request);
            callback.onSuccess((Object)response);
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    private RestLiDebugRequestHandler findDebugRequestHandler(Request request) {
        String[] pathSegments = URIUtil.tokenizePath((String)request.getURI().getPath());
        String debugHandlerId = null;
        RestLiDebugRequestHandler resultDebugHandler = null;
        for (int i = 0; i < pathSegments.length; ++i) {
            String pathSegment = pathSegments[i];
            if (!pathSegment.equals(DEBUG_PATH_SEGMENT)) continue;
            if (i >= pathSegments.length - 1) break;
            debugHandlerId = pathSegments[i + 1];
            break;
        }
        if (debugHandlerId != null) {
            resultDebugHandler = this._debugHandlers.get(debugHandlerId);
        }
        return resultDebugHandler;
    }

    private static RequestExecutionReport createEmptyExecutionReport() {
        return new RequestExecutionReportBuilder().build();
    }

    @Override
    protected void doHandleStreamRequest(final StreamRequest request, final RequestContext requestContext, final Callback<StreamResponse> callback) {
        if (this.isDocumentationRequest((Request)request)) {
            Messages.toRestRequest((StreamRequest)request, (Callback)new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                }

                public void onSuccess(RestRequest result) {
                    RestLiServer.this.handleDocumentationRequest(result, (Callback<RestResponse>)Messages.toRestCallback((Callback)callback));
                }
            });
        } else if (this.isMultiplexedRequest((Request)request)) {
            String acceptTypeHeader = request.getHeader("Accept");
            if (acceptTypeHeader != null) {
                List<String> acceptTypes = MIMEParse.parseAcceptType(acceptTypeHeader);
                for (String acceptType : acceptTypes) {
                    if (!acceptType.equalsIgnoreCase("multipart/related")) continue;
                    callback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)406, (String)"This server cannot handle multiplexed requests that have an accept type of multipart/related")));
                    return;
                }
            }
            Messages.toRestRequest((StreamRequest)request, (Callback)new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                }

                public void onSuccess(RestRequest result) {
                    RestLiServer.this.handleMultiplexedRequest(result, requestContext, (Callback<RestResponse>)Messages.toRestCallback((Callback)callback));
                }
            });
        } else {
            String header = request.getHeader("Content-Type");
            if (header != null) {
                ContentType contentType = null;
                try {
                    contentType = new ContentType(header);
                }
                catch (ParseException e) {
                    callback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)400, (String)("Unable to parse Content-Type: " + header))));
                    return;
                }
                if (contentType.getBaseType().equalsIgnoreCase("multipart/related")) {
                    MultiPartMIMEReader multiPartMIMEReader = MultiPartMIMEReader.createAndAcquireStream((StreamRequest)request);
                    TopLevelReaderCallback firstPartReader = new TopLevelReaderCallback(requestContext, callback, multiPartMIMEReader, request);
                    multiPartMIMEReader.registerReaderCallback((MultiPartMIMEReaderCallback)firstPartReader);
                    return;
                }
            }
            Messages.toRestRequest((StreamRequest)request, (Callback)new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    callback.onError(e);
                }

                public void onSuccess(RestRequest result) {
                    StreamResponseCallbackAdaptor streamResponseCallbackAdaptor = new StreamResponseCallbackAdaptor(callback);
                    RestLiDebugRequestHandler debugHandlerForRequest = RestLiServer.this.findDebugRequestHandler((Request)request);
                    if (debugHandlerForRequest != null) {
                        RestLiServer.this.handleDebugRequest(debugHandlerForRequest, result, requestContext, null, new RestResponseExecutionCallbackAdapter((Callback<RestResponse>)Messages.toRestCallback((Callback)callback)));
                    } else {
                        RestLiServer.this.handleResourceRequest(result, requestContext, streamResponseCallbackAdaptor, null, false);
                    }
                }
            });
        }
    }

    private boolean verifyAttachmentSupportNotNeeded(Request request, Callback<RestResponse> callback) {
        Map requestHeaders = request.getHeaders();
        try {
            ContentType contentType;
            String contentTypeString = (String)requestHeaders.get("Content-Type");
            if (contentTypeString != null && (contentType = new ContentType(contentTypeString)).getBaseType().equalsIgnoreCase("multipart/related")) {
                callback.onError((Throwable)RestException.forError((int)415, (String)"This server cannot handle requests with a content type of multipart/related"));
                return true;
            }
            String acceptTypeHeader = (String)requestHeaders.get("Accept");
            if (acceptTypeHeader != null) {
                List<String> acceptTypes = MIMEParse.parseAcceptType(acceptTypeHeader);
                for (String acceptType : acceptTypes) {
                    if (!acceptType.equalsIgnoreCase("multipart/related")) continue;
                    callback.onError((Throwable)RestException.forError((int)406, (String)"This server cannot handle requests with an accept type of multipart/related"));
                    return true;
                }
            }
        }
        catch (ParseException parseException) {
            callback.onError((Throwable)RestException.forError((int)400, (String)"Unable to parse content or accept types."));
            return true;
        }
        return false;
    }

    private class StreamResponseCallbackAdaptor
    implements RequestExecutionCallback<RestResponse> {
        private final Callback<StreamResponse> _streamResponseCallback;

        private StreamResponseCallbackAdaptor(Callback<StreamResponse> streamResponseCallback) {
            this._streamResponseCallback = streamResponseCallback;
        }

        @Override
        public void onError(Throwable e, RequestExecutionReport executionReport, RestLiAttachmentReader requestAttachmentReader, RestLiResponseAttachments responseAttachments) {
            if (requestAttachmentReader != null && !requestAttachmentReader.haveAllAttachmentsFinished()) {
                try {
                    requestAttachmentReader.drainAllAttachments();
                }
                catch (RestLiAttachmentReaderException restLiAttachmentReaderException) {
                    // empty catch block
                }
            }
            if (responseAttachments != null) {
                responseAttachments.getResponseAttachmentsBuilder().build().abortAllDataSources(e);
            }
            this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)((RestException)e)));
        }

        @Override
        public void onSuccess(RestResponse result, RequestExecutionReport executionReport, RestLiResponseAttachments responseAttachments) {
            if (responseAttachments != null && responseAttachments.getResponseAttachmentsBuilder().getCurrentSize() > 0) {
                ByteStringWriter firstPartWriter = new ByteStringWriter(result.getEntity());
                MultiPartMIMEWriter multiPartMIMEWriter = AttachmentUtils.createMultiPartMIMEWriter((ByteStringWriter)firstPartWriter, (String)result.getHeader("Content-Type"), (MultiPartMIMEWriter.Builder)responseAttachments.getResponseAttachmentsBuilder());
                StreamResponse streamResponse = MultiPartMIMEStreamResponseFactory.generateMultiPartMIMEStreamResponse((String)"related", (MultiPartMIMEWriter)multiPartMIMEWriter, Collections.emptyMap(), (Map)result.getHeaders(), (int)result.getStatus(), (List)result.getCookies());
                this._streamResponseCallback.onSuccess((Object)streamResponse);
            } else {
                this._streamResponseCallback.onSuccess((Object)Messages.toStreamResponse((RestResponse)result));
            }
        }
    }

    private class FirstPartReaderCallback
    implements SinglePartMIMEReaderCallback {
        private final TopLevelReaderCallback _topLevelReaderCallback;
        private final MultiPartMIMEReader.SinglePartMIMEReader _singlePartMIMEReader;
        private final ByteString.Builder _builder = new ByteString.Builder();

        public FirstPartReaderCallback(TopLevelReaderCallback topLevelReaderCallback, MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader) {
            this._topLevelReaderCallback = topLevelReaderCallback;
            this._singlePartMIMEReader = singlePartMIMEReader;
        }

        public void onPartDataAvailable(ByteString partData) {
            this._builder.append(partData);
            this._singlePartMIMEReader.requestPartData();
        }

        public void onFinished() {
            this._topLevelReaderCallback.setRequestPayload(this._builder.build());
        }

        public void onDrainComplete() {
            this._topLevelReaderCallback.onStreamError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)500, (String)"Serious error. There should never be a call to drain part data when decoding the first part in a multipart mime response.")));
        }

        public void onStreamError(Throwable throwable) {
        }
    }

    private class TopLevelReaderCallback
    implements MultiPartMIMEReaderCallback {
        private final RestRequestBuilder _restRequestBuilder;
        private volatile ByteString _requestPayload = null;
        private final RequestContext _requestContext;
        private final Callback<StreamResponse> _streamResponseCallback;
        private final MultiPartMIMEReader _multiPartMIMEReader;
        private final StreamRequest _streamRequest;

        private TopLevelReaderCallback(RequestContext requestContext, Callback<StreamResponse> streamResponseCallback, MultiPartMIMEReader multiPartMIMEReader, StreamRequest streamRequest) {
            this._restRequestBuilder = new RestRequestBuilder(streamRequest);
            this._requestContext = requestContext;
            this._streamResponseCallback = streamResponseCallback;
            this._multiPartMIMEReader = multiPartMIMEReader;
            this._streamRequest = streamRequest;
        }

        private void setRequestPayload(ByteString requestPayload) {
            this._requestPayload = requestPayload;
        }

        public void onNewPart(MultiPartMIMEReader.SinglePartMIMEReader singlePartMIMEReader) {
            if (this._requestPayload == null) {
                ContentType contentType;
                Map singlePartHeaders = singlePartMIMEReader.dataSourceHeaders();
                String contentTypeString = (String)singlePartHeaders.get("Content-Type");
                if (contentTypeString == null) {
                    this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)400, (String)"Incorrect multipart/related payload. First part must contain the Content-Type!")));
                    return;
                }
                try {
                    contentType = new ContentType(contentTypeString);
                }
                catch (ParseException e) {
                    this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)400, (String)("Unable to parse Content-Type: " + contentTypeString))));
                    return;
                }
                String baseType = contentType.getBaseType();
                if (!baseType.equalsIgnoreCase("application/json") && !baseType.equalsIgnoreCase("application/x-pson")) {
                    this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)415, (String)("Unknown Content-Type for first part of multipart/related payload: " + contentType.toString()))));
                    return;
                }
                this._restRequestBuilder.setHeader("Content-Type", contentTypeString);
                FirstPartReaderCallback firstPartReaderCallback = new FirstPartReaderCallback(this, singlePartMIMEReader);
                singlePartMIMEReader.registerReaderCallback((SinglePartMIMEReaderCallback)firstPartReaderCallback);
                singlePartMIMEReader.requestPartData();
            } else {
                this._restRequestBuilder.setEntity(this._requestPayload);
                StreamResponseCallbackAdaptor streamResponseCallbackAdaptor = new StreamResponseCallbackAdaptor(this._streamResponseCallback);
                RestLiDebugRequestHandler debugHandlerForRequest = RestLiServer.this.findDebugRequestHandler((Request)this._streamRequest);
                if (debugHandlerForRequest != null) {
                    RestLiServer.this.handleDebugRequest(debugHandlerForRequest, this._restRequestBuilder.build(), this._requestContext, new RestLiAttachmentReader(this._multiPartMIMEReader), streamResponseCallbackAdaptor);
                } else {
                    RestLiServer.this.handleResourceRequest(this._restRequestBuilder.build(), this._requestContext, streamResponseCallbackAdaptor, new RestLiAttachmentReader(this._multiPartMIMEReader), false);
                }
            }
        }

        public void onFinished() {
            if (this._requestPayload == null) {
                this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)400, (String)"Did not receive any parts in the multipart mime request!")));
                return;
            }
            this._restRequestBuilder.setEntity(this._requestPayload);
            StreamResponseCallbackAdaptor streamResponseCallbackAdaptor = new StreamResponseCallbackAdaptor(this._streamResponseCallback);
            RestLiDebugRequestHandler debugHandlerForRequest = RestLiServer.this.findDebugRequestHandler((Request)this._streamRequest);
            if (debugHandlerForRequest != null) {
                RestLiServer.this.handleDebugRequest(debugHandlerForRequest, this._restRequestBuilder.build(), this._requestContext, null, streamResponseCallbackAdaptor);
            } else {
                RestLiServer.this.handleResourceRequest(this._restRequestBuilder.build(), this._requestContext, streamResponseCallbackAdaptor, null, false);
            }
        }

        public void onDrainComplete() {
        }

        public void onStreamError(Throwable throwable) {
            if (throwable instanceof MultiPartIllegalFormatException) {
                this._streamResponseCallback.onError((Throwable)Messages.toStreamException((RestException)RestException.forError((int)400, (String)"Illegally formed multipart payload")));
                return;
            }
            this._streamResponseCallback.onError(throwable);
        }
    }

    private class RestResponseExecutionCallbackAdapter
    implements RequestExecutionCallback<RestResponse> {
        private final Callback<RestResponse> _wrappedCallback;

        public RestResponseExecutionCallbackAdapter(Callback<RestResponse> wrappedCallback) {
            this._wrappedCallback = wrappedCallback;
        }

        @Override
        public void onError(Throwable e, RequestExecutionReport executionReport, RestLiAttachmentReader requestAttachmentReader, RestLiResponseAttachments responseAttachments) {
            this._wrappedCallback.onError(e);
        }

        @Override
        public void onSuccess(RestResponse result, RequestExecutionReport executionReport, RestLiResponseAttachments responseAttachments) {
            this._wrappedCallback.onSuccess((Object)result);
        }
    }
}

